/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.calendar.outlook;

import com.jacob.com.ComThread;
import com.jacob.com.LibraryLoader;
import java.applet.Applet;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.calendar.AppletDrawer;
import org.silverpeas.calendar.ServletConnector;
import org.silverpeas.calendar.api.CalendarEntriesFactory;
import org.silverpeas.calendar.api.CalendarEntry;
import org.silverpeas.calendar.outlook.OutlookSecurityManager;
import org.silverpeas.calendar.outlook.SilverOutlookEventsList;

public class ImportEventsApplet
extends Applet {
    private static final long serialVersionUID = 1L;
    private transient CalendarEntriesFactory journalList = null;
    private transient AppletDrawer appletDrawer = new AppletDrawer();
    private transient ServletConnector servletConnector = null;
    private int nbDaysBefore = 7;

    @Override
    public String getAppletInfo() {
        return "Applet d'import de rendez-vous de Outlook vers Silverpeas";
    }

    @Override
    public void init() {
        super.init();
        try {
            this.initLibrary();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.journalList = new CalendarEntriesFactory(this.getParameter("SESSIONID"));
        this.servletConnector = new ServletConnector(this.getParameter("SERVLETURL"));
        String paramDaysBefore = this.getParameter("NBDAYSBEFORE");
        if (paramDaysBefore != null) {
            this.nbDaysBefore = Integer.parseInt(this.getParameter("NBDAYSBEFORE"));
        }
    }

    private void initLibrary() throws IOException {
        Logger.getLogger("ImportEventsApplet").info("Copying " + LibraryLoader.getPreferredDLLName());
        File tempJacobDll = this.copyDll(LibraryLoader.getPreferredDLLName());
        System.setProperty("jacob.dll.path", tempJacobDll.getAbsolutePath());
    }

    private File copyDll(String fileName) throws IOException {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName + ".dll");
        try {
            File dllFile = File.createTempFile(fileName, ".dll");
            FileUtils.copyInputStreamToFile((InputStream)in, (File)dllFile);
            return dllFile;
        }
        catch (IOException ioex) {
            IOUtils.closeQuietly((InputStream)in);
            Logger.getLogger("ImportEventsApplet").throwing("ImportEventsApplet", "copyDll", ioex);
            throw ioex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        try {
            super.start();
            this.appletDrawer.initApplet(this, "Silverpeas : synchronization Outlook en cours\n");
            SilverOutlookEventsList myEvents = new SilverOutlookEventsList();
            myEvents.initWithCurrentOutlook();
            myEvents.loadItemsList(this.nbDaysBefore);
            OutlookSecurityManager securityManager = null;
            try {
                securityManager = new OutlookSecurityManager(myEvents.getOOutlook());
                securityManager.setSecurityWarningsEnabled(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            List<CalendarEntry> headers = this.journalList.buildJournalHeadersList(myEvents);
            if (securityManager != null) {
                securityManager.setSecurityWarningsEnabled(true);
            }
            String report = this.servletConnector.sendHeaders(headers);
            this.appletDrawer.addMessage(report);
            this.appletDrawer.addMessage("Synchronisation terminee");
            if (!report.isEmpty()) {
                this.appletDrawer.showDialog();
            }
        }
        finally {
            ComThread.Release();
            FileUtils.deleteQuietly((File)new File(System.getProperty("jacob.dll.path")));
        }
    }
}

