/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.social.linkedin.api.Comment;
import org.springframework.social.linkedin.api.Comments;
import org.springframework.social.linkedin.api.CurrentShare;
import org.springframework.social.linkedin.api.Likes;
import org.springframework.social.linkedin.api.LinkedInNetworkUpdate;
import org.springframework.social.linkedin.api.LinkedInNetworkUpdates;
import org.springframework.social.linkedin.api.LinkedInProfile;
import org.springframework.social.linkedin.api.NetworkUpdateOperations;
import org.springframework.social.linkedin.api.NetworkUpdateParameters;
import org.springframework.social.linkedin.api.NewShare;
import org.springframework.social.linkedin.api.UpdateContentShare;
import org.springframework.social.linkedin.api.UpdateTypeInput;
import org.springframework.social.linkedin.api.impl.AbstractTemplate;
import org.springframework.web.client.RestOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NetworkUpdateTemplate
extends AbstractTemplate
implements NetworkUpdateOperations {
    static final String UPDATES_URL = "https://api.linkedin.com/v1/people/{id}/network/updates?{&count}{&start}{&scope}{type}{&before}{&after}{&show-hidden-members}&format=json";
    static final String UPDATE_COMMENTS_URL = "https://api.linkedin.com/v1/people/~/network/updates/key={key}/update-comments?format=json";
    static final String UPDATE_LIKES_URL = "https://api.linkedin.com/v1/people/~/network/updates/key={key}/likes?format=json";
    static final String UPDATE_IS_LIKED_URL = "https://api.linkedin.com/v1/people/~/network/updates/key={key}/is-liked?format=json";
    static final String ACTIVITY_URL = "https://api.linkedin.com/v1/people/~/person-activities";
    static final String CURRENT_SHARE_URL = "https://api.linkedin.com/v1/people/~:(current-share)";
    static final String SHARE_URL = "https://api.linkedin.com/v1/people/~/shares";
    public static final int DEFAULT_START = 0;
    public static final int DEFAULT_COUNT = 10;
    private static final String UPDATE_TYPE_ALL_STRING;
    private final RestOperations restOperations;

    public NetworkUpdateTemplate(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    @Override
    public List<LinkedInNetworkUpdate> getNetworkUpdates() {
        NetworkUpdateParameters parameters = new NetworkUpdateParameters(null, false, 0, 10, null, null, true, false, Collections.<UpdateTypeInput>emptyList());
        return this.getNetworkUpdates(parameters);
    }

    @Override
    public List<LinkedInNetworkUpdate> getNetworkUpdates(int start, int count) {
        NetworkUpdateParameters parameters = new NetworkUpdateParameters(null, false, start, count, null, null, true, false, Collections.<UpdateTypeInput>emptyList());
        return this.getNetworkUpdates(parameters);
    }

    @Override
    public List<LinkedInNetworkUpdate> getNetworkUpdates(NetworkUpdateParameters parameters) {
        return this.getNetworkUpdates(parameters, LinkedInNetworkUpdates.class).getUpdates();
    }

    @Override
    public List<Comment> getNetworkUpdateComments(String updateKey) {
        return ((Comments)this.restOperations.getForObject(UPDATE_COMMENTS_URL, Comments.class, new Object[]{updateKey})).getComments();
    }

    @Override
    public void createNetworkUpdate(String update) {
        HashMap<String, String> activity = new HashMap<String, String>();
        activity.put("contentType", "linkedin-html");
        activity.put("body", update);
        this.restOperations.postForLocation(ACTIVITY_URL, activity, new Object[0]);
    }

    @Override
    public CurrentShare getCurrentShare() {
        return ((UpdateContentShare)this.restOperations.getForObject(CURRENT_SHARE_URL, UpdateContentShare.class, new Object[0])).getCurrentShare();
    }

    @Override
    public URI share(NewShare share) {
        return this.restOperations.postForLocation(SHARE_URL, (Object)share, new Object[0]);
    }

    @Override
    public void likeNetworkUpdate(String updateKey) {
        this.restOperations.put(UPDATE_IS_LIKED_URL, (Object)Boolean.TRUE, new Object[]{updateKey});
    }

    @Override
    public void unlikeNetworkUpdate(String updateKey) {
        this.restOperations.put(UPDATE_IS_LIKED_URL, (Object)Boolean.FALSE, new Object[]{updateKey});
    }

    @Override
    public void commentOnNetworkUpdate(String updateKey, String comment) {
        this.restOperations.postForLocation(UPDATE_COMMENTS_URL, Collections.singletonMap("comment", comment), new Object[]{updateKey});
    }

    @Override
    public List<LinkedInProfile> getNetworkUpdateLikes(String updateKey) {
        return ((Likes)this.restOperations.getForObject(UPDATE_LIKES_URL, Likes.class, new Object[]{updateKey})).getLikes();
    }

    @Override
    public String getNetworkUpdatesJson(NetworkUpdateParameters parameters) {
        return this.getNetworkUpdates(parameters, String.class);
    }

    private <T> T getNetworkUpdates(NetworkUpdateParameters parameters, Class<T> responseType) {
        return (T)this.restOperations.getForObject(this.expand(UPDATES_URL, parameters), responseType);
    }

    private URI expand(String url, NetworkUpdateParameters parameters) {
        String type = null;
        if (parameters.getUpdateAll()) {
            type = UPDATE_TYPE_ALL_STRING;
        } else if (parameters.getUpdateTypes() != null && parameters.getUpdateTypes().size() > 0) {
            StringBuffer b = new StringBuffer();
            for (UpdateTypeInput t : parameters.getUpdateTypes()) {
                b.append("&type=").append((Object)t);
            }
            type = b.toString();
        }
        Object[] variables = new Object[]{parameters.getUser() == null ? "~" : "id=" + parameters.getUser(), parameters.getRecordCount(), parameters.getRecordStart(), parameters.getSelf() ? "self" : null, type, parameters.getRecordsBefore() == null ? null : Long.valueOf(parameters.getRecordsBefore().getTime()), parameters.getRecordsAfter() == null ? null : Long.valueOf(parameters.getRecordsAfter().getTime()), parameters.getShowHidden() ? "true" : null};
        return this.expand(url, variables, false);
    }

    static {
        StringBuffer b = new StringBuffer();
        for (UpdateTypeInput t : UpdateTypeInput.values()) {
            b.append("&type=").append((Object)t);
        }
        UPDATE_TYPE_ALL_STRING = b.toString();
    }
}

