/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.cache.model;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import org.silverpeas.kernel.cache.model.SimpleCache;

public abstract class AbstractSimpleCache
implements SimpleCache {
    @Override
    public <T> T get(Object key, Class<T> classType) {
        Object value = this.get(key);
        if (value == null || !classType.isAssignableFrom(value.getClass())) {
            return null;
        }
        return (T)value;
    }

    @Override
    public <T> T computeIfAbsent(Object key, Class<T> classType, Supplier<T> valueSupplier) {
        Objects.requireNonNull(valueSupplier);
        T value = this.get(key, classType);
        if (value == null && (value = valueSupplier.get()) != null) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public String add(Object value) {
        String uniqueKey = UUID.randomUUID().toString();
        this.put(uniqueKey, value);
        return uniqueKey;
    }

    public abstract Map<Object, Object> getAll();
}

