/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.bundle;

import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.silverpeas.kernel.bundle.SilverpeasBundle;
import org.silverpeas.kernel.bundle.VariableResolver;

public class SettingBundle
implements SilverpeasBundle {
    public static final String GENERAL_BUNDLE_NAME = "org.silverpeas.general";
    private final String name;
    private final Function<String, ResourceBundle> loader;

    protected SettingBundle(String name, Function<String, ResourceBundle> loader) {
        this.name = name;
        this.loader = loader;
    }

    @Override
    public boolean exists() {
        try {
            ResourceBundle bundle = this.getWrappedBundle();
            return bundle != null;
        }
        catch (MissingResourceException ex) {
            return false;
        }
    }

    @Override
    public Set<String> keySet() {
        ResourceBundle bundle = this.getWrappedBundle();
        return bundle.keySet();
    }

    @Override
    public boolean containsKey(String key) {
        ResourceBundle bundle = this.getWrappedBundle();
        return bundle.containsKey(key);
    }

    @Override
    public String getBaseBundleName() {
        return this.name;
    }

    @Override
    public String getString(String key) {
        ResourceBundle bundle = this.getWrappedBundle();
        return VariableResolver.resolve(bundle.getString(key));
    }

    public String getString(String key, String defaultValue) {
        try {
            String value = this.getString(key);
            return SettingBundle.isDefined(value) ? value : defaultValue;
        }
        catch (MissingResourceException ex) {
            if (SettingBundle.isDefined(ex.getKey())) {
                return defaultValue;
            }
            throw ex;
        }
    }

    public String[] getList(String key) {
        return this.getList(key, ",");
    }

    public String[] getList(String key, String separator) {
        String value = this.getString(key);
        return (String[])Stream.of(value.trim().split(separator)).map(String::trim).filter(s -> !s.isBlank()).toArray(String[]::new);
    }

    public String[] getList(String key, String[] defaultValue) {
        return this.getList(key, defaultValue, ",");
    }

    public String[] getList(String key, String[] defaultValue, String separator) {
        try {
            String[] value = this.getList(key, separator);
            return value.length > 0 ? value : defaultValue;
        }
        catch (MissingResourceException e) {
            if (SettingBundle.isDefined(e.getKey())) {
                return defaultValue;
            }
            throw e;
        }
    }

    public boolean getBoolean(String key) {
        return SettingBundle.asBoolean(this.getString(key));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            String value = this.getString(key);
            return SettingBundle.isDefined(value) ? SettingBundle.asBoolean(value) : defaultValue;
        }
        catch (MissingResourceException ex) {
            if (SettingBundle.isDefined(ex.getKey())) {
                return defaultValue;
            }
            throw ex;
        }
    }

    public long getLong(String key) {
        return Long.parseLong(this.getString(key));
    }

    public long getLong(String key, long defaultValue) {
        try {
            String value = this.getString(key);
            return SettingBundle.isDefined(value) ? Long.parseLong(value) : defaultValue;
        }
        catch (MissingResourceException ex) {
            if (SettingBundle.isDefined(ex.getKey())) {
                return defaultValue;
            }
            throw ex;
        }
    }

    public float getFloat(String key) {
        return Float.parseFloat(this.getString(key));
    }

    public float getFloat(String key, float defaultValue) {
        try {
            String value = this.getString(key);
            return SettingBundle.isDefined(value) ? Float.parseFloat(value) : defaultValue;
        }
        catch (MissingResourceException ex) {
            if (SettingBundle.isDefined(ex.getKey())) {
                return defaultValue;
            }
            throw ex;
        }
    }

    public int getInteger(String key) {
        return Integer.parseInt(this.getString(key));
    }

    public int getInteger(String key, int defaultValue) {
        try {
            String value = this.getString(key);
            return SettingBundle.isDefined(value) ? Integer.parseInt(value) : defaultValue;
        }
        catch (MissingResourceException ex) {
            if (SettingBundle.isDefined(ex.getKey())) {
                return defaultValue;
            }
            throw ex;
        }
    }

    public ResourceBundle asResourceBundle() {
        return this.getWrappedBundle();
    }

    public Properties asProperties() {
        ResourceBundle bundle = this.getWrappedBundle();
        Properties properties = new Properties();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            properties.put(key, bundle.getObject(key));
        }
        return properties;
    }

    private ResourceBundle getWrappedBundle() {
        return this.loader.apply(this.name);
    }

    private static boolean isDefined(String value) {
        return value != null && !value.trim().isEmpty();
    }

    private static boolean asBoolean(String value) {
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "oui".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }
}

