/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.bundle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.silverpeas.kernel.util.StringUtil;

public class PropertyValuesList
extends ArrayList<String> {
    public static PropertyValuesList with(String ... values) {
        PropertyValuesList list = new PropertyValuesList();
        Collections.addAll(list, values);
        return list;
    }

    private PropertyValuesList() {
    }

    public String[] asStringArray() {
        return this.toArray(new String[this.size()]);
    }

    public String[] asStringArray(String defaultValue) {
        return this.asStringList(defaultValue).toArray(new String[this.size()]);
    }

    public List<String> asStringList(String defaultValue) {
        ArrayList<String> values = new ArrayList<String>(this.size());
        values.addAll(this.stream().map(value -> StringUtil.defaultStringIfNotDefined(value, defaultValue)).collect(Collectors.toList()));
        return values;
    }

    public Integer[] asIntegerArray() {
        return this.asIntegerArray(null);
    }

    public List<Integer> asIntegerList() {
        return this.asIntegerList(null);
    }

    public Integer[] asIntegerArray(Integer defaultValue) {
        return this.asIntegerList(defaultValue).toArray(new Integer[this.size()]);
    }

    public List<Integer> asIntegerList(Integer defaultValue) {
        ArrayList<Integer> values = new ArrayList<Integer>(this.size());
        values.addAll(this.stream().map(value -> StringUtil.isDefined(value) ? Integer.valueOf(Integer.parseInt(value)) : defaultValue).collect(Collectors.toList()));
        return values;
    }
}

