/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.wbe;

import java.time.OffsetDateTime;
import java.util.StringJoiner;
import java.util.UUID;
import org.silverpeas.core.admin.user.model.User;

public abstract class WbeUser {
    private final String spSessionId;
    private final User user;
    private String accessToken;
    private OffsetDateTime lastEditionDate;

    protected WbeUser(String spSessionId, User user) {
        this.spSessionId = spSessionId;
        this.user = user;
        this.renewAccessToken();
    }

    public abstract String getId();

    public OffsetDateTime getLastEditionDate() {
        return this.lastEditionDate;
    }

    public String getSilverpeasSessionId() {
        return this.spSessionId;
    }

    public User asSilverpeas() {
        return this.user;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setLastEditionDateAtNow() {
        this.lastEditionDate = OffsetDateTime.now();
    }

    public User getUser() {
        return this.user;
    }

    private void renewAccessToken() {
        this.accessToken = UUID.randomUUID().toString();
    }

    public String toString() {
        return new StringJoiner(", ", WbeUser.class.getSimpleName() + "[", "]").add("spSessionId=" + this.getSilverpeasSessionId()).add("user=" + this.getId()).add("accessToken='" + this.getAccessToken() + "'").add("lastEditionDate='" + String.valueOf(this.getLastEditionDate()) + "'").toString();
    }
}

