/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.token.persistent;

import java.util.UUID;
import org.silverpeas.core.persistence.EntityReference;
import org.silverpeas.core.security.token.Token;
import org.silverpeas.core.security.token.TokenGenerationParameter;
import org.silverpeas.core.security.token.TokenGenerator;
import org.silverpeas.core.security.token.exception.TokenGenerationException;
import org.silverpeas.core.security.token.persistent.PersistentResourceToken;

public class PersistentResourceTokenGenerator
implements TokenGenerator {
    public static final String RESOURCE_PARAM = "Resource";

    public PersistentResourceToken generate(TokenGenerationParameter ... parameters) {
        EntityReference ref = null;
        for (TokenGenerationParameter parameter : parameters) {
            if (!RESOURCE_PARAM.equals(parameter.key())) continue;
            ref = (EntityReference)parameter.value();
            break;
        }
        if (ref == null) {
            throw new TokenGenerationException("The resource for which the token has to be generated isn't defined!");
        }
        String value = UUID.randomUUID().toString().replaceAll("[^0-9a-zA-Z]", "");
        return new PersistentResourceToken(ref, value);
    }

    @Override
    public <T extends Token> T renew(T token) {
        String value = UUID.randomUUID().toString().replaceAll("[^0-9a-zA-Z]", "");
        if (!(token instanceof PersistentResourceToken)) {
            throw new IllegalArgumentException("The token type isn't taken in charge by this generator. Excepted " + PersistentResourceToken.class.getSimpleName() + " but was " + token.getClass().getSimpleName());
        }
        ((PersistentResourceToken)token).setValue(value);
        return token;
    }
}

