/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.reminder;

import java.text.MessageFormat;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.persistence.datasource.model.EntityIdentifier;

@Embeddable
public class ReminderIdentifier
implements EntityIdentifier {
    private static final long serialVersionUID = -8752448963347095783L;
    private static final String ID_PREFIX = "Reminder#";
    private static final MessageFormat SCHEDULED_JOB_NAME = new MessageFormat("Reminder#{0}");
    @Column(name="id", columnDefinition="varchar(41)", length=41)
    private String id;

    @Override
    public ReminderIdentifier fromString(String id) {
        if (!id.startsWith(ID_PREFIX) && id.length() != 41) {
            throw new IllegalArgumentException("The specified id " + id + " isn't of a reminder's one");
        }
        this.id = id;
        return this;
    }

    @Override
    public ReminderIdentifier generateNewId(String ... parameters) {
        this.id = SCHEDULED_JOB_NAME.format(new Object[]{UUID.randomUUID().toString().replaceAll("-", "")});
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReminderIdentifier other = (ReminderIdentifier)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.id).isEquals();
    }

    @Override
    public String asString() {
        return this.id;
    }
}

