/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.system;

import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSProducer;
import org.silverpeas.core.notification.system.AbstractResourceEvent;
import org.silverpeas.core.notification.system.JMSOperation;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.notification.system.ResourceEventNotifier;

public abstract class JMSResourceEventNotifier<R extends Serializable, T extends AbstractResourceEvent<?>>
implements ResourceEventNotifier<R, T> {
    public abstract Destination getDestination();

    protected abstract T createResourceEventFrom(ResourceEvent.Type var1, R ... var2);

    @Override
    public void notify(T event) {
        JMSOperation.realize(context -> {
            JMSProducer producer = context.createProducer();
            producer.send(this.getDestination(), (Serializable)event);
        });
    }

    @Override
    public void notifyEventOn(ResourceEvent.Type type, R ... resource) {
        this.notify((T)this.createResourceEventFrom(type, (Serializable[])resource));
    }
}

