/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.date;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.util.DateUtil;

public class TemporalConverter {
    private static final Conversion<Instant, Instant> INSTANT_TO_INSTANT = Conversion.of(Instant.class, t -> {
        if (t.equals(Instant.MIN) || t.equals(DateUtil.MINIMUM_DATE.toInstant())) {
            return Instant.MIN;
        }
        if (t.equals(Instant.MAX) || t.equals(DateUtil.MAXIMUM_DATE.toInstant())) {
            return Instant.MAX;
        }
        return t;
    });
    private static final Conversion<LocalDate, Instant> LOCAL_DATE_TO_INSTANT = Conversion.of(LocalDate.class, t -> {
        if (t.equals(LocalDate.MIN)) {
            return Instant.MIN;
        }
        if (t.equals(LocalDate.MAX)) {
            return Instant.MAX;
        }
        return t.atStartOfDay(ZoneOffset.UTC).toInstant();
    });
    private static final Conversion<LocalDateTime, Instant> LOCAL_DATE_TIME_TO_INSTANT = Conversion.of(LocalDateTime.class, t -> {
        if (t.equals(LocalDateTime.MIN)) {
            return Instant.MIN;
        }
        if (t.equals(LocalDateTime.MAX)) {
            return Instant.MAX;
        }
        ZoneOffset offset = ZoneId.systemDefault().getRules().getOffset((LocalDateTime)t);
        return t.toInstant(offset);
    });
    private static final Conversion<OffsetDateTime, Instant> OFFSET_DATE_TIME_TO_INSTANT = Conversion.of(OffsetDateTime.class, t -> {
        if (t.equals(OffsetDateTime.MIN)) {
            return Instant.MIN;
        }
        if (t.equals(OffsetDateTime.MAX)) {
            return Instant.MAX;
        }
        return t.toInstant();
    });
    private static final Conversion<ZonedDateTime, Instant> ZONED_DATE_TIME_TO_INSTANT = Conversion.of(ZonedDateTime.class, t -> {
        if (t.toOffsetDateTime().equals(OffsetDateTime.MIN)) {
            return Instant.MIN;
        }
        if (t.toOffsetDateTime().equals(OffsetDateTime.MAX)) {
            return Instant.MAX;
        }
        return t.toInstant();
    });

    private TemporalConverter() {
    }

    @SafeVarargs
    public static <T> T applyByType(Temporal temporal, Conversion<? extends Temporal, T> ... conversions) {
        Objects.requireNonNull(temporal);
        Objects.requireNonNull(conversions);
        if (conversions.length == 0) {
            throw new IllegalArgumentException("Expected at least one conversion function");
        }
        return (T)Stream.of(conversions).filter(c -> c.accepts(temporal)).findFirst().orElseThrow(() -> new IllegalArgumentException("Temporal parameter isn't of the expected type: " + Stream.of(conversions).map(Conversion::getAcceptedType).collect(Collectors.joining()))).apply(temporal);
    }

    public static void consumeByType(Temporal temporal, Consumer<LocalDate> dateConsumer, Consumer<OffsetDateTime> dateTimeConsumer) {
        Objects.requireNonNull(temporal);
        Objects.requireNonNull(dateTimeConsumer);
        Objects.requireNonNull(dateConsumer);
        TemporalConverter.applyByType(temporal, Conversion.of(LocalDate.class, date -> {
            dateConsumer.accept((LocalDate)date);
            return null;
        }), Conversion.of(OffsetDateTime.class, dateTime -> {
            dateTimeConsumer.accept((OffsetDateTime)dateTime);
            return null;
        }));
    }

    public static OffsetDateTime asOffsetDateTime(Temporal temporal) {
        Objects.requireNonNull(temporal);
        return (OffsetDateTime)TemporalConverter.applyByType(temporal, Conversion.of(LocalDate.class, t -> t.atStartOfDay(ZoneOffset.UTC).toOffsetDateTime()), Conversion.of(LocalDateTime.class, t -> t.atOffset(ZoneOffset.UTC)), Conversion.of(OffsetDateTime.class, Function.identity()), Conversion.of(ZonedDateTime.class, ZonedDateTime::toOffsetDateTime), Conversion.of(Instant.class, t -> t.atOffset(ZoneOffset.UTC)));
    }

    public static ZonedDateTime asZonedDateTime(Temporal temporal) {
        Objects.requireNonNull(temporal);
        return (ZonedDateTime)TemporalConverter.applyByType(temporal, Conversion.of(LocalDate.class, t -> t.atStartOfDay(ZoneOffset.UTC)), Conversion.of(LocalDateTime.class, t -> t.atZone(ZoneId.of(ZoneOffset.UTC.getId()))), Conversion.of(OffsetDateTime.class, OffsetDateTime::toZonedDateTime), Conversion.of(ZonedDateTime.class, Function.identity()), Conversion.of(Instant.class, t -> t.atZone(ZoneOffset.UTC)));
    }

    public static LocalDate asLocalDate(Temporal temporal) {
        Objects.requireNonNull(temporal);
        return (LocalDate)TemporalConverter.applyByType(temporal, Conversion.of(LocalDate.class, Function.identity()), Conversion.of(LocalDateTime.class, LocalDateTime::toLocalDate), Conversion.of(OffsetDateTime.class, OffsetDateTime::toLocalDate), Conversion.of(ZonedDateTime.class, ZonedDateTime::toLocalDate), Conversion.of(Instant.class, t -> LocalDate.ofInstant(t, ZoneOffset.UTC)));
    }

    public static LocalDate asLocalDate(Temporal temporal, ZoneId zoneId) {
        Objects.requireNonNull(temporal);
        return (LocalDate)TemporalConverter.applyByType(temporal, Conversion.of(LocalDate.class, Function.identity()), Conversion.of(LocalDateTime.class, t -> t.atZone(ZoneId.of(ZoneOffset.UTC.getId())).withZoneSameInstant(zoneId).toLocalDate()), Conversion.of(OffsetDateTime.class, t -> t.atZoneSameInstant(zoneId).toLocalDate()), Conversion.of(ZonedDateTime.class, t -> t.withZoneSameInstant(zoneId).toLocalDate()), Conversion.of(Instant.class, t -> LocalDate.ofInstant(t, zoneId)));
    }

    public static Instant asInstant(Temporal temporal) {
        Objects.requireNonNull(temporal);
        return (Instant)TemporalConverter.applyByType(temporal, LOCAL_DATE_TO_INSTANT, LOCAL_DATE_TIME_TO_INSTANT, OFFSET_DATE_TIME_TO_INSTANT, ZONED_DATE_TIME_TO_INSTANT, INSTANT_TO_INSTANT);
    }

    public static Date asDate(Temporal temporal) {
        Objects.requireNonNull(temporal);
        Instant instant = (Instant)TemporalConverter.applyByType(temporal, LOCAL_DATE_TO_INSTANT, LOCAL_DATE_TIME_TO_INSTANT, OFFSET_DATE_TIME_TO_INSTANT, ZONED_DATE_TIME_TO_INSTANT, INSTANT_TO_INSTANT);
        Date date = instant == Instant.MIN ? new Date(Long.MIN_VALUE) : (instant == Instant.MAX ? new Date(Long.MAX_VALUE) : Date.from(instant));
        return date;
    }

    public static class Conversion<T extends Temporal, R> {
        private final Class<T> type;
        private final Function<T, R> converter;

        public static <T extends Temporal, R> Conversion<T, R> of(Class<T> type, Function<T, R> converter) {
            return new Conversion<T, R>(type, converter);
        }

        private Conversion(Class<T> type, Function<T, R> converter) {
            this.type = type;
            this.converter = converter;
        }

        public boolean accepts(Temporal temporal) {
            return this.type.isAssignableFrom(temporal.getClass());
        }

        public R apply(Temporal temporal) {
            return this.converter.apply((Temporal)this.type.cast(temporal));
        }

        public String getAcceptedType() {
            return this.type.getSimpleName();
        }
    }
}

