/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.indicator;

import java.time.Instant;
import org.silverpeas.core.contribution.indicator.ContributionIndicatorRegistry;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.kernel.util.Pair;

public interface NewContributionIndicator {
    public static boolean isNewContribution(Contribution contribution) {
        return NewContributionIndicator.isNewContribution(contribution.getIdentifier(), contribution.getLastUpdateDate().toInstant());
    }

    public static boolean isNewContribution(ContributionIdentifier cId, Instant lastUpdateInstant) {
        return ContributionIndicatorRegistry.get().getNewContributionIndicatorBy(cId).map(i -> i.isNew(lastUpdateInstant)).orElse(false);
    }

    public Pair<String, String> relatedToComponentAndResourceType();

    public boolean isNew(Instant var1);
}

