/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.io.InputStream;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.EventOperationResult;
import org.silverpeas.core.calendar.ICalendarImportResult;
import org.silverpeas.core.calendar.icalendar.ICalendarImporter;
import org.silverpeas.core.calendar.repository.CalendarEventRepository;
import org.silverpeas.core.importexport.ImportDescriptor;
import org.silverpeas.core.importexport.ImportException;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.OperationContext;
import org.silverpeas.core.persistence.datasource.model.jpa.JpaEntityReflection;
import org.silverpeas.core.security.html.HtmlSanitizer;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class ICalendarEventImportProcessor {
    @Inject
    private ICalendarImporter iCalendarImporter;
    @Inject
    private CalendarEventRepository eventRepository;

    public ICalendarImportResult importInto(Calendar calendar, InputStream inputStream) throws ImportException {
        return this.importInto(calendar, ImportDescriptor.withInputStream(inputStream));
    }

    public ICalendarImportResult importInto(Calendar calendar, Reader reader) throws ImportException {
        return this.importInto(calendar, ImportDescriptor.withReader(reader));
    }

    protected ICalendarImportResult importInto(Calendar calendar, ImportDescriptor descriptor) throws ImportException {
        if (!calendar.isPersisted()) {
            throw new IllegalArgumentException("The calendar " + calendar.getTitle() + " (id = " + calendar.getId() + ") doesn't exist in Silverpeas");
        }
        OperationContext.fromCurrentRequester();
        ICalendarImportResult importResult = new ICalendarImportResult();
        this.iCalendarImporter.imports(descriptor, events -> Transaction.performInOne(() -> {
            events.forEach(e -> {
                CalendarEvent event = (CalendarEvent)e.getLeft();
                List occurrences = (List)e.getRight();
                this.adjustSomeProperties(event.asCalendarComponent());
                EventOperationResult result = this.importEvent(calendar, event, occurrences);
                result.created().ifPresent(ce -> importResult.incAdded());
                result.updated().ifPresent(ue -> importResult.incUpdated());
            });
            return null;
        }));
        return importResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventOperationResult importEvent(Calendar calendar, CalendarEvent event, List<CalendarEventOccurrence> occurrences) {
        EventOperationResult eventOperationResult;
        OperationContext.addStates(OperationContext.State.IMPORT);
        try {
            eventOperationResult = Transaction.performInOne(() -> {
                if (calendar.isSynchronized() && calendar.getLastSynchronizationDate().isPresent()) {
                    event.setLastSynchronizationDate(calendar.getLastSynchronizationDate().get());
                }
                EventOperationResult result = this.importEventOnly(calendar, event);
                if (!occurrences.isEmpty()) {
                    CalendarEvent resultEvent = Objects.requireNonNull(EventImportResult.eventFrom(result));
                    EventOperationResult occurrenceImportResult = this.importOccurrencesOnly(resultEvent, occurrences);
                    this.adjustOccurrenceImportResult(occurrenceImportResult, result);
                }
                return result;
            });
        }
        catch (Throwable throwable) {
            OperationContext.removeStates(OperationContext.State.IMPORT);
            throw throwable;
        }
        OperationContext.removeStates(OperationContext.State.IMPORT);
        return eventOperationResult;
    }

    private void adjustOccurrenceImportResult(EventOperationResult occurrenceImportResult, EventOperationResult result) {
        occurrenceImportResult.updated().ifPresent(e -> {
            if (result.created().isEmpty()) {
                result.withUpdated((CalendarEvent)e);
            }
        });
        occurrenceImportResult.instance().ifPresent(i -> {
            if (result.created().isEmpty() && result.updated().isEmpty()) {
                result.withUpdated(i.getCalendarEvent());
            }
        });
    }

    private void adjustSomeProperties(CalendarComponent component) {
        if (StringUtil.isNotDefined((String)component.getTitle())) {
            component.setTitle("N/A");
        } else if (component.getTitle().length() > 255) {
            component.setTitle(StringUtil.truncate((String)component.getTitle().trim(), (int)255));
        }
        if (StringUtil.isDefined((String)component.getDescription())) {
            String sanitizedDesc = HtmlSanitizer.get().sanitize(component.getDescription().trim());
            if (sanitizedDesc.length() > 2000) {
                component.setDescription(StringUtil.truncate((String)sanitizedDesc, (int)2000));
            } else {
                component.setDescription(sanitizedDesc);
            }
        }
        if (component.getLocation().length() > 255) {
            component.setLocation(StringUtil.truncate((String)component.getLocation().trim(), (int)255));
        }
    }

    private EventOperationResult importEventOnly(Calendar calendar, CalendarEvent event) {
        EventOperationResult result;
        Optional<CalendarEvent> persistedEvent = this.getExistingCalendarEvent(calendar, event);
        if (persistedEvent.isPresent()) {
            CalendarEvent existingEvent = persistedEvent.get();
            result = new EventImportResult().withExisting(existingEvent);
            if (this.wasUpdated(event, existingEvent)) {
                Date lastUpdateDateBeforeUpdate = existingEvent.getLastUpdateDate();
                EventOperationResult updateResult = existingEvent.updateFrom(event);
                Optional<CalendarEvent> updatedEvent = updateResult.updated();
                if (updatedEvent.isPresent() && !updatedEvent.get().getLastUpdateDate().equals(lastUpdateDateBeforeUpdate)) {
                    result = updateResult;
                }
            } else if (event.isSynchronized()) {
                existingEvent.setLastSynchronizationDate(event.getLastSynchronizationDate());
                this.eventRepository.save(existingEvent);
            }
        } else {
            result = new EventOperationResult().withCreated(event.planOn(calendar));
        }
        return result;
    }

    private EventOperationResult importOccurrencesOnly(CalendarEvent event, List<CalendarEventOccurrence> occurrencesToImport) {
        Mutable result = Mutable.of((Object)new EventOperationResult());
        HashMap<String, CalendarEventOccurrence> existingOccurrences = new HashMap<String, CalendarEventOccurrence>();
        event.getPersistedOccurrences().forEach(o -> existingOccurrences.put(o.getOriginalStartDate().toString(), (CalendarEventOccurrence)o));
        occurrencesToImport.stream().sorted(CalendarEventOccurrence.COMPARATOR_BY_ORIGINAL_DATE_ASC).forEach(o -> {
            o.setCalendarEvent(event);
            this.adjustSomeProperties(o.asCalendarComponent());
            Optional<CalendarEventOccurrence> existingOccurrence = Optional.ofNullable((CalendarEventOccurrence)existingOccurrences.remove(o.getOriginalStartDate().toString()));
            if (existingOccurrence.isPresent()) {
                if (this.wasUpdated((CalendarEventOccurrence)o, existingOccurrence.get())) {
                    result.set((Object)existingOccurrence.get().updateFrom((CalendarEventOccurrence)o));
                }
            } else {
                o.saveIntoPersistence();
                ((EventOperationResult)result.get()).withUpdated(o.getCalendarEvent());
            }
        });
        if (!existingOccurrences.isEmpty()) {
            ((EventOperationResult)result.get()).withUpdated(event);
        }
        existingOccurrences.forEach((originalStartDate, occurrence) -> event.deleteOnly((CalendarEventOccurrence)occurrence));
        return (EventOperationResult)result.get();
    }

    private Optional<CalendarEvent> getExistingCalendarEvent(Calendar calendar, CalendarEvent event) {
        Optional<CalendarEvent> optionalPersistedEvent = calendar.externalEvent(event.getExternalId());
        if (optionalPersistedEvent.isEmpty()) {
            optionalPersistedEvent = calendar.event(event.getExternalId());
        }
        return optionalPersistedEvent;
    }

    private boolean wasUpdated(CalendarEvent imported, CalendarEvent existing) {
        if (imported.getLastUpdateDate() == null) {
            JpaEntityReflection.setUpdateData(imported.asCalendarComponent(), existing.getLastUpdater(), existing.getLastUpdateDate());
            return true;
        }
        return imported.getLastUpdateDate().after(existing.getLastUpdateDate()) || imported.getRecurrence() != null && !imported.getRecurrence().equals(existing.getRecurrence());
    }

    private boolean wasUpdated(CalendarEventOccurrence imported, CalendarEventOccurrence existing) {
        if (imported.getLastUpdateDate() == null) {
            JpaEntityReflection.setUpdateData(imported.asCalendarComponent(), existing.getLastUpdater(), existing.getLastUpdateDate());
            return true;
        }
        return imported.getLastUpdateDate().after(existing.getLastUpdateDate());
    }

    private static class EventImportResult
    extends EventOperationResult {
        private CalendarEvent existing;

        private EventImportResult() {
        }

        public static CalendarEvent eventFrom(EventOperationResult result) {
            EventImportResult importResult;
            Optional<CalendarEvent> createdEvent = result.created();
            if (createdEvent.isPresent()) {
                return createdEvent.get();
            }
            Optional<CalendarEvent> updatedEvent = result.updated();
            if (updatedEvent.isPresent()) {
                return updatedEvent.get();
            }
            if (result instanceof EventImportResult && (importResult = (EventImportResult)result).existing().isPresent()) {
                return importResult.existing;
            }
            return null;
        }

        public EventImportResult withExisting(CalendarEvent event) {
            this.existing = event;
            return this;
        }

        public Optional<CalendarEvent> existing() {
            return Optional.ofNullable(this.existing);
        }
    }
}

