/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.repository.CalendarRepository;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;

public class ComponentInstanceCalendars
extends ArrayList<Calendar> {
    private static final Comparator<Calendar> CALENDAR_COMPARATOR_BY_CREATION_DATE_ASC = Comparator.comparing(SilverpeasJpaEntity::getCreationDate);

    private ComponentInstanceCalendars(List<Calendar> calendars) {
        super(calendars);
    }

    static ComponentInstanceCalendars getByComponentInstanceId(String instanceId) {
        CalendarRepository calendarRepository = CalendarRepository.get();
        ComponentInstanceCalendars list = new ComponentInstanceCalendars(calendarRepository.getByComponentInstanceId(instanceId));
        list.sort(CALENDAR_COMPARATOR_BY_CREATION_DATE_ASC);
        return list;
    }

    public Optional<Calendar> getMainCalendar() {
        return this.stream().filter(Calendar::isMain).findFirst();
    }
}

