/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.silverpeas.core.calendar.AttendeeSet;
import org.silverpeas.core.calendar.AttributeSet;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.Priority;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.persistence.datasource.OperationContext;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@Table(name="sb_cal_components")
public class CalendarComponent
extends SilverpeasJpaEntity<CalendarComponent, UuidIdentifier> {
    static final int DESCRIPTION_MAX_LENGTH = 2000;
    static final int TITLE_MAX_LENGTH = 255;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="calendarId", referencedColumnName="id", nullable=false)
    @NotNull
    private Calendar calendar;
    @Embedded
    private Period period;
    @Column(name="title", nullable=false)
    @Size(min=1, max=255)
    @NotNull
    private @Size(min=1, max=255) @NotNull String title;
    @Column(name="description")
    @Size(max=2000)
    private @Size(max=2000) String description;
    @Column(name="location")
    @Size(max=255)
    private @Size(max=255) String location;
    @Column(name="priority", nullable=false)
    @NotNull
    private Priority priority = Priority.NORMAL;
    @Embedded
    private AttributeSet attributes = new AttributeSet();
    @Column(nullable=false)
    private long sequence = 0L;
    @Transient
    private boolean sequenceUpdated = false;
    @Embedded
    private AttendeeSet attendees = new AttendeeSet(this);

    protected CalendarComponent() {
    }

    CalendarComponent(Period period) {
        this.period = period;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period newPeriod) {
        this.period = newPeriod;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = Objects.requireNonNullElse(title, "");
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = Objects.requireNonNullElse(description, "");
    }

    public String getLocation() {
        return this.location == null ? "" : this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public AttendeeSet getAttendees() {
        return this.attendees;
    }

    public long getSequence() {
        return this.sequence;
    }

    public CalendarComponent copy() {
        CalendarComponent copy = new CalendarComponent();
        copy.calendar = this.calendar;
        copy.sequence = this.sequence;
        copy.sequenceUpdated = false;
        return this.copyTo(copy);
    }

    public CalendarComponent copyTo(CalendarComponent anotherComponent) {
        anotherComponent.title = this.title;
        anotherComponent.description = this.description;
        anotherComponent.location = this.location;
        anotherComponent.period = this.period.copy();
        anotherComponent.priority = this.priority;
        anotherComponent.attributes = this.attributes.copy();
        if (OperationContext.statesOf(OperationContext.State.IMPORT)) {
            if (StringUtil.isNotDefined((String)anotherComponent.getId())) {
                AttendeeSet existingAttendees = anotherComponent.attendees;
                anotherComponent.attendees = new AttendeeSet(anotherComponent);
                existingAttendees.copyTo(anotherComponent.attendees);
            }
        } else {
            anotherComponent.attendees = new AttendeeSet(anotherComponent);
            this.attendees.copyTo(anotherComponent.attendees);
        }
        return anotherComponent;
    }

    void setSequence(long sequence) {
        this.sequence = sequence;
        this.sequenceUpdated = true;
    }

    void incrementSequence() {
        if (!this.sequenceUpdated) {
            this.setSequence(this.sequence + 1L);
        }
    }

    @Override
    protected void performBeforeUpdate() {
        if (!OperationContext.statesOf(OperationContext.State.IMPORT)) {
            this.incrementSequence();
        }
        super.performBeforeUpdate();
    }

    protected boolean isModifiedSince(CalendarComponent previous) {
        if (!this.getTitle().equals(previous.getTitle())) {
            return true;
        }
        if (!this.getDescription().equals(previous.getDescription())) {
            return true;
        }
        if (!this.getLocation().equals(previous.getLocation())) {
            return true;
        }
        if (!this.getPeriod().equals(previous.getPeriod())) {
            return true;
        }
        if (this.getPriority() != previous.getPriority()) {
            return true;
        }
        return !this.getAttributes().equals(previous.getAttributes());
    }

    @PostLoad
    private void onceLoaded() {
        this.attendees = this.attendees.withCalendarComponent(this);
    }
}

