/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.cache.service;

import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.cache.service.CacheAccessor;
import org.silverpeas.kernel.cache.service.InMemoryCache;

public class SessionCacheAccessor
implements CacheAccessor<SimpleCache> {
    private static final String CURRENT_REQUESTER_KEY = User.class.getName() + "_CURRENT_REQUESTER";
    private static final String CURRENT_SESSION_KEY = "@SessionCache@";

    public SimpleCache newSessionCache(User user) {
        InMemoryCache sessionCache = new InMemoryCache();
        sessionCache.put((Object)CURRENT_REQUESTER_KEY, (Object)user);
        this.setCurrentSessionCache((SimpleCache)sessionCache);
        return sessionCache;
    }

    public void setCurrentSessionCache(SimpleCache sessionCache) {
        if (sessionCache.get((Object)CURRENT_REQUESTER_KEY) == null) {
            throw new IllegalArgumentException("Attempt to set a non session cache as the current session cache");
        }
        CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)CURRENT_SESSION_KEY, (Object)sessionCache);
    }

    public SimpleCache getCurrentSessionCache() {
        return (SimpleCache)CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)CURRENT_SESSION_KEY, InMemoryCache.class);
    }

    public User getUser(SimpleCache sessionCache) {
        User user = (User)sessionCache.get((Object)CURRENT_REQUESTER_KEY, User.class);
        if (user == null) {
            throw new IllegalArgumentException("A non session cache is passed as argument");
        }
        return user;
    }

    public SimpleCache getCache() {
        return this.getCurrentSessionCache();
    }
}

