/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.logging;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.util.logging.Log;
import org.silverpeas.kernel.logging.Level;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Interceptor
@Log
@Priority(value=2000)
public class LogAnnotationProcessor {
    protected static final String SYSTEM_DEFAULT_BEFORE_PATTERN = "[SYSTEM] Invocation of {0}#{1}";
    protected static final String SYSTEM_DEFAULT_AFTER_PATTERN = "[SYSTEM] Invocation of {0}#{1} done in {2}ms";
    protected static final String USER_DEFAULT_BEFORE_PATTERN = "[{0} ({1})] Invocation of {2}#{3}";
    protected static final String USER_DEFAULT_AFTER_PATTERN = "[{0} ({1})] Invocation of {2}#{3} done in {4}ms";
    protected static final String SYSTEM_BEFORE_PATTERN = "[SILVERPEAS] {0}";
    protected static final String SYSTEM_AFTER_PATTERN = "[SILVERPEAS] {0}. Done in {1}ms";
    protected static final String USER_BEFORE_PATTERN = "[{0} ({1})] {2}";
    protected static final String USER_AFTER_PATTERN = "[{0} ({1})] {2}. Done in {3}ms";

    @AroundInvoke
    public Object produceLogRecords(InvocationContext context) throws Exception {
        LogProperties logProps = this.getLogProperties(context);
        SilverLogger logger = SilverLogger.getLogger((Object)context.getTarget());
        Object result = StringUtil.isDefined((String)logProps.getMessage()) ? this.logCustomMessage(logger, logProps, context) : this.logDefaultMessage(logger, logProps, context);
        return result;
    }

    private Object logCustomMessage(SilverLogger logger, LogProperties logProps, InvocationContext context) throws Exception {
        Result result;
        UserDetail currentUser = UserDetail.getCurrentRequester();
        String message = this.computeCustomMessage(logProps.getMessage(), context);
        if (currentUser == null) {
            logger.log(logProps.getLevel(), SYSTEM_BEFORE_PATTERN, new Object[]{message});
            result = this.executeMethod(context);
            if (logProps.isDualRecord()) {
                logger.log(logProps.getLevel(), SYSTEM_AFTER_PATTERN, new Object[]{message, result.getTime()});
            }
        } else {
            logger.log(logProps.getLevel(), USER_BEFORE_PATTERN, new Object[]{currentUser.getDisplayedName(), currentUser.getId(), message});
            result = this.executeMethod(context);
            if (logProps.isDualRecord()) {
                logger.log(logProps.getLevel(), USER_AFTER_PATTERN, new Object[]{currentUser.getDisplayedName(), currentUser.getId(), message, result.getTime()});
            }
        }
        return result.getValue();
    }

    private Object logDefaultMessage(SilverLogger logger, LogProperties logProps, InvocationContext context) throws Exception {
        Result result;
        UserDetail currentUser = UserDetail.getCurrentRequester();
        String className = context.getMethod().getDeclaringClass().getSimpleName();
        String message = this.computeDefaultMessage(context);
        if (currentUser == null) {
            logger.log(logProps.getLevel(), SYSTEM_DEFAULT_BEFORE_PATTERN, new Object[]{className, message});
            result = this.executeMethod(context);
            if (logProps.isDualRecord()) {
                logger.log(logProps.getLevel(), SYSTEM_DEFAULT_AFTER_PATTERN, new Object[]{className, message, result.getTime()});
            }
        } else {
            logger.log(logProps.getLevel(), USER_DEFAULT_BEFORE_PATTERN, new Object[]{currentUser.getDisplayedName(), currentUser.getId(), className, message});
            result = this.executeMethod(context);
            if (logProps.isDualRecord()) {
                logger.log(logProps.getLevel(), USER_DEFAULT_AFTER_PATTERN, new Object[]{currentUser.getDisplayedName(), currentUser.getId(), className, message, result.getTime()});
            }
        }
        return result.getValue();
    }

    private LogProperties getLogProperties(InvocationContext context) {
        Method method = context.getMethod();
        Log log = method.getAnnotation(Log.class);
        if (log == null) {
            log = method.getDeclaringClass().getAnnotation(Log.class);
        }
        Objects.requireNonNull(log);
        return new LogProperties(log);
    }

    private String computeDefaultMessage(InvocationContext context) {
        Object[] parameters = context.getParameters();
        String p = Stream.of(parameters).map(Object::toString).collect(Collectors.joining(", "));
        return context.getMethod().getName() + "(" + p + ")";
    }

    private String computeCustomMessage(String messagePattern, InvocationContext context) {
        Object[] parameters = (String[])Stream.of(context.getParameters()).map(Object::toString).toArray(String[]::new);
        return MessageFormat.format(messagePattern, parameters);
    }

    private Result executeMethod(InvocationContext context) throws Exception {
        long start = System.currentTimeMillis();
        Object result = context.proceed();
        long duration = System.currentTimeMillis() - start;
        return new Result(duration, result);
    }

    private static class Result {
        private final long time;
        private final Object value;

        public Result(long time, Object value) {
            this.time = time;
            this.value = value;
        }

        public long getTime() {
            return this.time;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private static class LogProperties {
        private final String message;
        private final boolean dualRecord;
        private final Level level;

        public LogProperties(Log log) {
            this.message = log.message().trim();
            this.dualRecord = log.dualRecord();
            this.level = log.level();
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isDualRecord() {
            return this.dualRecord;
        }

        public Level getLevel() {
            return this.level;
        }
    }
}

