/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.silverpeas.kernel.logging.SilverLogger;

public class DeletingPathVisitor
extends SimpleFileVisitor<Path> {
    public static boolean deleteQuietly(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.walkFileTree(path, new DeletingPathVisitor());
            }
        }
        catch (IOException e) {
            SilverLogger.getLogger(DeletingPathVisitor.class).error((Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        try {
            FileVisitResult fileVisitResult = super.visitFile(file, attrs);
            return fileVisitResult;
        }
        finally {
            Files.delete(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        try {
            FileVisitResult fileVisitResult = super.postVisitDirectory(dir, exc);
            return fileVisitResult;
        }
        finally {
            Files.delete(dir);
        }
    }
}

