/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.SystemWrapper;

public class DefaultSystemWrapper
implements SystemWrapper {
    private void loadSystemSettings() {
        Properties systemSettings = new Properties();
        Path systemSettingsPath = Paths.get(System.getenv("SILVERPEAS_HOME"), "properties", "org", "silverpeas", "systemSettings.properties");
        if (!Files.exists(systemSettingsPath, new LinkOption[0])) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "System settings file not found at {0}", systemSettingsPath);
            return;
        }
        try (FileReader reader = new FileReader(systemSettingsPath.toFile());){
            systemSettings.load(reader);
        }
        catch (IOException e) {
            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
        }
        systemSettings.stringPropertyNames().forEach(key -> this.setProperty((String)key, systemSettings.getProperty((String)key)));
    }

    public DefaultSystemWrapper() {
        this.loadSystemSettings();
    }
}

