/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription;

import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.notification.NodeEvent;
import org.silverpeas.core.subscription.AbstractProfiledResourceSubscriptionListener;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionService;
import org.silverpeas.core.subscription.service.NodeSubscription;
import org.silverpeas.core.subscription.service.NodeSubscriptionResource;

@Bean
@Singleton
public class SubscriptionNodeEventListener
extends AbstractProfiledResourceSubscriptionListener<NodeDetail, NodeEvent> {
    protected NodeSubscriptionResource getSubscriptionResource(NodeDetail resource) {
        return NodeSubscriptionResource.from(resource.getNodePK());
    }

    @Override
    protected boolean isSubscriptionEnabled(NodeDetail resource) {
        return true;
    }

    @Transactional
    public void onMove(NodeEvent event) {
        NodeDetail nodeAfterMove;
        NodeDetail nodeBeforeMove = (NodeDetail)event.getTransition().getBefore();
        if (this.isNodeMovedInAnotherApp(nodeBeforeMove, nodeAfterMove = (NodeDetail)event.getTransition().getAfter())) {
            SubscriptionService service = this.getSubscriptionService();
            NodeSubscriptionResource resource = this.getSubscriptionResource(nodeAfterMove);
            service.getByResource(this.getSubscriptionResource(nodeBeforeMove)).forEach(subscription -> {
                NodeSubscription renewedSubscription = new NodeSubscription(subscription.getSubscriber(), resource, subscription.getCreatorId());
                service.unsubscribe((Subscription)subscription);
                service.subscribe(renewedSubscription);
            });
        }
    }

    private boolean isNodeMovedInAnotherApp(NodeDetail nodeBeforeMove, NodeDetail nodeAfterMove) {
        return !nodeBeforeMove.getIdentifier().getComponentInstanceId().equals(nodeAfterMove.getIdentifier().getComponentInstanceId());
    }
}

