/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.status;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.socialnetwork.model.SocialInformation;
import org.silverpeas.core.socialnetwork.status.SocialInformationStatus;
import org.silverpeas.core.socialnetwork.status.Status;
import org.silverpeas.kernel.util.StringUtil;

@Repository
public class StatusDao {
    private static final String INSERT_STATUS = "INSERT INTO sb_sn_status (id, userid, creationdate, description) VALUES (?, ?, ?, ?)";
    private static final String SELECT_LAST_STATUS_BY_USERID = " SELECT * FROM sb_sn_status WHERE userid = ? ORDER BY creationdate DESC";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int changeStatus(Connection connection, Status status) throws SQLException {
        int id = DBUtil.getNextId((String)"sb_sn_status", (String)"id");
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement(INSERT_STATUS);
            pstmt.setInt(1, id);
            pstmt.setInt(2, status.getUserId());
            pstmt.setTimestamp(3, new Timestamp(status.getCreationDate().getTime()));
            pstmt.setString(4, status.getDescription());
            pstmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)pstmt);
        }
        return id;
    }

    public Status getLastStatus(Connection connection, int userid) throws SQLException {
        Status status = new Status();
        try (PreparedStatement pstmt = connection.prepareStatement(SELECT_LAST_STATUS_BY_USERID);){
            pstmt.setInt(1, userid);
            try (ResultSet rs = pstmt.executeQuery();){
                if (rs.next()) {
                    status.setId(rs.getInt(1));
                    status.setUserId(rs.getInt(2));
                    status.setCreationDate(new Date(rs.getTimestamp(3).getTime()));
                    status.setDescription(rs.getString(4));
                }
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialInformation> getAllStatus(Connection connection, int userId, Date begin, Date end) throws SQLException {
        List<SocialInformation> list;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT id,userid, creationdate, description FROM sb_sn_status WHERE userid = ? and creationdate >= ? and creationdate <= ? ORDER BY creationdate DESC";
            pstmt = connection.prepareStatement(query);
            pstmt.setInt(1, userId);
            pstmt.setTimestamp(2, new Timestamp(begin.getTime()));
            pstmt.setTimestamp(3, new Timestamp(end.getTime()));
            rs = pstmt.executeQuery();
            list = this.getSocialInformationList(rs);
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)pstmt);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SocialInformation> getSocialInformationListOfMyContacts(Connection connection, List<String> myContactsIds, Date begin, Date end) throws SQLException {
        List<SocialInformation> list;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT id,userid, creationdate, description FROM sb_sn_status WHERE userid in (" + StatusDao.toSqlString(myContactsIds) + ") AND creationdate >= ? AND creationdate <= ? ORDER BY creationdate DESC";
            pstmt = connection.prepareStatement(query);
            pstmt.setTimestamp(1, new Timestamp(begin.getTime()));
            pstmt.setTimestamp(2, new Timestamp(end.getTime()));
            rs = pstmt.executeQuery();
            list = this.getSocialInformationList(rs);
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)pstmt);
        return list;
    }

    private List<SocialInformation> getSocialInformationList(ResultSet rs) throws SQLException {
        ArrayList<SocialInformation> statusList = new ArrayList<SocialInformation>();
        while (rs.next()) {
            Status status = new Status();
            status.setId(rs.getInt(1));
            status.setUserId(rs.getInt(2));
            status.setCreationDate(new Date(rs.getTimestamp(3).getTime()));
            status.setDescription(rs.getString(4));
            if (!StringUtil.isDefined((String)status.getDescription())) continue;
            statusList.add(new SocialInformationStatus(status));
        }
        return statusList;
    }

    private static String toSqlString(List<String> list) {
        StringBuilder result = new StringBuilder(100);
        if (list == null || list.isEmpty()) {
            return "''";
        }
        int i = 0;
        for (String var : list) {
            if (i != 0) {
                result.append(",");
            }
            result.append("'").append(var).append("'");
            ++i;
        }
        return result.toString();
    }
}

