/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authorization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.ResourceIdentifier;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.cache.service.VolatileCacheServiceProvider;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.security.authorization.AbstractAccessController;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.authorization.ComponentAccessController;
import org.silverpeas.core.security.authorization.ComponentInstancePublicationAccessControlExtension;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.core.security.authorization.NodeAccessController;
import org.silverpeas.core.security.authorization.PublicationAccessControl;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.MemoizedBooleanSupplier;
import org.silverpeas.core.util.MemoizedSupplier;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
public class PublicationAccessController
extends AbstractAccessController<PublicationPK>
implements PublicationAccessControl {
    private static final String DATA_MANAGER_CONTEXT_KEY = "PublicationAccessControllerDataManager";
    private final ComponentAccessControl componentAccessController;
    private final NodeAccessControl nodeAccessController;

    @Inject
    PublicationAccessController(ComponentAccessControl componentAccessController, NodeAccessControl nodeAccessController) {
        this.componentAccessController = componentAccessController;
        this.nodeAccessController = nodeAccessController;
    }

    static DataManager getDataManager(AccessControlContext context) {
        DataManager manager = (DataManager)context.get(DATA_MANAGER_CONTEXT_KEY, DataManager.class);
        if (manager == null) {
            manager = new DataManager(context);
            context.put(DATA_MANAGER_CONTEXT_KEY, (Object)manager);
        }
        return manager;
    }

    @Override
    public boolean isUserAuthorized(String userId, ResourceIdentifier id) {
        ContributionIdentifier pubId = (ContributionIdentifier)id;
        PublicationPK pubPK = new PublicationPK(pubId.getLocalId(), pubId.getComponentInstanceId());
        PublicationDetail pub = PublicationService.get().getDetail(pubPK);
        return this.isUserAuthorized(userId, pub);
    }

    @Override
    public Stream<PublicationDetail> filterAuthorizedByUser(String userId, Collection<PublicationDetail> pubs, AccessControlContext context) {
        DataManager dataManager = PublicationAccessController.getDataManager(context).loadCachesWithLoadedPublications(userId, pubs);
        return this.filterAuthorizedByUser((Collection<PublicationPK>)dataManager.getGivenPublicationPks(), userId, context).map(x$0 -> dataManager.getPublicationData((PublicationPK)x$0));
    }

    @Override
    public Stream<PublicationPK> filterAuthorizedByUser(Collection<PublicationPK> pks, String userId, AccessControlContext context) {
        DataManager dataManager = PublicationAccessController.getDataManager(context).loadCaches(userId, pks);
        return pks.stream().map(dataManager::prepareCheckFor).filter(p -> this.isUserAuthorized(userId, (PublicationPK)p, context));
    }

    @Override
    public boolean isUserAuthorized(String userId, PublicationDetail pubDetail) {
        return this.isUserAuthorized(userId, pubDetail, AccessControlContext.init());
    }

    @Override
    public boolean isUserAuthorized(String userId, PublicationDetail pubDetail, AccessControlContext context) {
        PublicationAccessController.getDataManager(context).loadCachesWithLoadedPublication(pubDetail);
        return this.isUserAuthorized(userId, pubDetail.getPK(), context);
    }

    public boolean isUserAuthorized(String userId, PublicationPK pubPk, AccessControlContext context) {
        return this.isUserAuthorizedByContext(userId, pubPk, context, this.getUserRoles(userId, pubPk, context));
    }

    private boolean isUserAuthorizedByContext(String userId, PublicationPK pubPk, AccessControlContext context, Set<SilverpeasRole> userRoles) {
        if (userRoles.isEmpty()) {
            return false;
        }
        Set operations = context.getOperations();
        if (AccessControlOperation.isSearchActionFrom((Collection)operations)) {
            return true;
        }
        SilverpeasRole safeHighestUserRole = this.getSafeSilverpeasRole(userRoles);
        String instanceId = pubPk.getInstanceId();
        boolean isCreationContext = !PublicationAccessController.isNotCreationContext(pubPk.getId(), pubPk.getInstanceId());
        DataManager dataManager = PublicationAccessController.getDataManager(context);
        PublicationDetail publicationDetail = isCreationContext ? null : dataManager.loadPublication(pubPk).getCurrentPublication();
        Mutable authorized = Mutable.of((Object)(isCreationContext || publicationDetail != null ? 1 : 0));
        MemoizedBooleanSupplier canPublicationBePersistedOrDeleted = new MemoizedBooleanSupplier(() -> this.getComponentExtension(instanceId).canPublicationBePersistedOrDeletedBy(publicationDetail, instanceId, userId, safeHighestUserRole, context));
        Supplier<Optional<Location>> mainLocationSupplier = dataManager.getPublicationMainLocationSupplier(pubPk);
        if (this.isPublicationIntoTopicTrackerTrashFolder(context, instanceId, publicationDetail, mainLocationSupplier)) {
            ComponentAccessController.DataManager componentDataManager = ComponentAccessController.getDataManager(context);
            boolean rightOnTopicsEnabled = componentDataManager.isRightOnTopicsEnabled(pubPk.getInstanceId());
            boolean noSpecificRightsAndCanPutInTrash = !rightOnTopicsEnabled && canPublicationBePersistedOrDeleted.getAsBoolean();
            boolean specificRightsAndAdminOrAuthorNotUser = rightOnTopicsEnabled && (safeHighestUserRole == SilverpeasRole.ADMIN || publicationDetail.isPublicationEditor(userId));
            authorized.set((Object)(noSpecificRightsAndCanPutInTrash || specificRightsAndAdminOrAuthorNotUser ? 1 : 0));
        } else {
            authorized.filter(arg_0 -> PublicationAccessController.lambda$isUserAuthorizedByContext$3(publicationDetail, (BooleanSupplier)canPublicationBePersistedOrDeleted, arg_0)).ifPresent(a -> authorized.set((Object)(publicationDetail != null && publicationDetail.isValid() && publicationDetail.isVisible() ? 1 : 0)));
            authorized.filter(a -> a != false && AccessControlOperation.isSharingActionFrom((Collection)operations)).ifPresent(a -> {
                User user = User.getById((String)userId);
                ComponentAccessController.DataManager componentDataManager = ComponentAccessController.getDataManager(context);
                authorized.set((Object)(!user.isAnonymous() && !user.isAccessGuest() && componentDataManager.isPublicationSharingEnabledForRole(instanceId, safeHighestUserRole) ? 1 : 0));
            });
            authorized.filter(a -> a != false && AccessControlOperation.isPersistActionFrom((Collection)operations)).ifPresent(arg_0 -> PublicationAccessController.lambda$isUserAuthorizedByContext$8(authorized, (BooleanSupplier)canPublicationBePersistedOrDeleted, arg_0));
        }
        return (Boolean)authorized.get();
    }

    private boolean isPublicationIntoTopicTrackerTrashFolder(AccessControlContext context, String instanceId, PublicationDetail publicationDetail, Supplier<Optional<Location>> mainLocationSupplier) {
        if (publicationDetail != null && this.isTopicTrackerSupported(instanceId, context)) {
            Optional<Location> mainLocation = mainLocationSupplier.get();
            return mainLocation.isPresent() && "1".equals(mainLocation.get().getId());
        }
        return false;
    }

    ComponentInstancePublicationAccessControlExtension getComponentExtension(String instanceId) {
        return ComponentInstancePublicationAccessControlExtension.getByInstanceId(instanceId);
    }

    private SilverpeasRole getSafeSilverpeasRole(Set<SilverpeasRole> userRoles) {
        SilverpeasRole safeHighestUserRole = SilverpeasRole.getHighestFrom(userRoles);
        if (safeHighestUserRole == null) {
            safeHighestUserRole = SilverpeasRole.READER;
        }
        return safeHighestUserRole;
    }

    @Override
    protected void fillUserRoles(Set<SilverpeasRole> userRoles, AccessControlContext context, String userId, PublicationPK publicationPK) {
        Set componentUserRoles;
        String instanceId = publicationPK.getInstanceId();
        String pubId = publicationPK.getId();
        if (PublicationAccessController.isNotCreationContext(pubId, instanceId)) {
            PublicationDetail pubDetail;
            DataManager dataManager = PublicationAccessController.getDataManager(context);
            boolean needPubLoading = !AccessControlOperation.isSearchActionFrom(dataManager.operations) && !dataManager.isLotOfDataMode();
            PublicationDetail publicationDetail = pubDetail = needPubLoading ? dataManager.loadPublication(publicationPK).getCurrentPublication() : null;
            if (needPubLoading && pubDetail == null || this.isTopicTrackerSupported(instanceId, context) && this.fillTopicTrackerRoles(userRoles, context, userId, publicationPK)) {
                return;
            }
        }
        if (this.componentAccessController.isUserAuthorized(componentUserRoles = this.componentAccessController.getUserRoles(userId, (Object)instanceId, context))) {
            userRoles.addAll(componentUserRoles);
        }
    }

    private boolean isTopicTrackerSupported(String instanceId, AccessControlContext context) {
        ComponentAccessController.DataManager componentDataManager = ComponentAccessController.getDataManager(context);
        return componentDataManager.isTopicTrackerSupported(instanceId);
    }

    private boolean isComponentInstanceRemoved(String instanceId, AccessControlContext context) {
        ComponentAccessController.DataManager componentDataManager = ComponentAccessController.getDataManager(context);
        return componentDataManager.isRemoved(instanceId);
    }

    private boolean fillTopicTrackerRoles(Set<SilverpeasRole> userRoles, AccessControlContext context, String userId, PublicationPK pubPK) {
        boolean rolesProcessed = this.isComponentInstanceRemoved(pubPK.getInstanceId(), context);
        if (!rolesProcessed && (rolesProcessed = this.fillTopicTrackerNodeRoles(userRoles, context, userId, pubPK)) && CollectionUtil.isEmpty(userRoles)) {
            rolesProcessed = this.fillTopicTrackerAliasRoles(userRoles, context, userId, pubPK);
        }
        return rolesProcessed;
    }

    private boolean fillTopicTrackerNodeRoles(Set<SilverpeasRole> userRoles, AccessControlContext context, String userId, PublicationPK pubPK) {
        block5: {
            try {
                Optional<Location> mainLocation = PublicationAccessController.getDataManager(context).getPublicationMainLocationSupplier(pubPK).get();
                if (mainLocation.isPresent()) {
                    if (pubPK.getInstanceId().equals(mainLocation.get().getInstanceId())) {
                        Set nodeUserRoles = this.nodeAccessController.getUserRoles(userId, mainLocation.get(), context);
                        if (this.nodeAccessController.isUserAuthorized(nodeUserRoles)) {
                            userRoles.addAll(nodeUserRoles);
                        }
                        break block5;
                    }
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                SilverLogger.getLogger((Object)this).error((Throwable)ex);
            }
        }
        return true;
    }

    private boolean fillTopicTrackerAliasRoles(Set<SilverpeasRole> userRoles, AccessControlContext context, String userId, PublicationPK pubPk) {
        Set operations = context.getOperations();
        if (!AccessControlOperation.isPersistActionFrom((Collection)operations) && !this.existsExternalMainLocationLinkedToRemovedComponentInstance(context, pubPk)) {
            try {
                boolean isSearch = AccessControlOperation.isSearchActionFrom((Collection)operations);
                List<Location> locations = PublicationAccessController.getDataManager(context).getAllPublicationAliases(pubPk);
                for (Location location : locations) {
                    Set nodeUserRoles;
                    if (isSearch && !location.getInstanceId().equals(pubPk.getInstanceId()) || !this.nodeAccessController.isUserAuthorized(nodeUserRoles = this.nodeAccessController.getUserRoles(userId, location, context))) continue;
                    userRoles.add(SilverpeasRole.USER);
                    break;
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        return true;
    }

    private boolean existsExternalMainLocationLinkedToRemovedComponentInstance(AccessControlContext context, PublicationPK pubPk) {
        return PublicationAccessController.getDataManager(context).getPublicationMainLocationSupplier(pubPk).get().filter(l -> !l.getInstanceId().equals(pubPk.getInstanceId())).map(l -> this.isComponentInstanceRemoved(l.getInstanceId(), context)).orElse(false);
    }

    private static boolean isNotCreationContext(String pubId, String instanceId) {
        return StringUtil.isInteger((String)pubId) && PublicationAccessController.notAVolatileResource(pubId, instanceId);
    }

    private static boolean notAVolatileResource(String pubId, String instanceId) {
        try {
            return !VolatileCacheServiceProvider.getSessionVolatileResourceCacheService().contains(pubId, instanceId);
        }
        catch (Exception ignore) {
            return true;
        }
    }

    private static /* synthetic */ void lambda$isUserAuthorizedByContext$8(Mutable authorized, BooleanSupplier canPublicationBePersistedOrDeleted, Boolean a) {
        authorized.set((Object)canPublicationBePersistedOrDeleted.getAsBoolean());
    }

    private static /* synthetic */ boolean lambda$isUserAuthorizedByContext$3(PublicationDetail publicationDetail, BooleanSupplier canPublicationBePersistedOrDeleted, Boolean a) {
        return a != false && publicationDetail != null && !canPublicationBePersistedOrDeleted.getAsBoolean();
    }

    static class DataManager {
        private final AccessControlContext context;
        private final Collection<AccessControlOperation> operations;
        private final PublicationService publicationService;
        private MemoizedSupplier<List<Location>> allLocations = null;
        private MemoizedSupplier<Optional<Location>> lastMainLocation = null;
        private PublicationDetail lastPublicationDetail = null;
        boolean lotOfDataMode;
        List<PublicationPK> givenPublicationPks = null;
        Map<PublicationPK, PublicationDetail> publicationCache = null;
        Map<String, List<Location>> locationsByPublicationCache = null;

        DataManager(AccessControlContext context) {
            this.context = context;
            this.operations = context.getOperations();
            this.lotOfDataMode = false;
            this.publicationService = PublicationService.get();
        }

        void loadCachesWithLoadedPublication(PublicationDetail pub) {
            this.loadPublicationCacheByDetails(Collections.singletonList(pub));
        }

        DataManager loadCachesWithLoadedPublications(String userId, Collection<PublicationDetail> pubs) {
            this.loadPublicationCacheByDetails(pubs);
            this.loadCaches(userId, this.givenPublicationPks);
            return this;
        }

        DataManager loadCaches(String userId, Collection<PublicationPK> pks) {
            if (this.locationsByPublicationCache != null || pks.isEmpty()) {
                return this;
            }
            this.lotOfDataMode = true;
            this.loadPublicationCacheByPks(pks);
            List<PublicationPK> pubRefs = this.publicationCache != null && !this.publicationCache.isEmpty() ? (Collection)this.publicationCache.values().stream().filter(Predicate.not(DataManager::isItAClone)).map(PublicationDetail::getPK).map(PubInAppInstanceRef::new).collect(Collectors.toList()) : this.givenPublicationPks;
            Set<String> instanceIds = pubRefs.stream().map(WAPrimaryKey::getInstanceId).collect(Collectors.toSet());
            NodeAccessController.DataManager nodeDataManager = NodeAccessController.getDataManager(this.context);
            nodeDataManager.loadCaches(userId, instanceIds);
            Set<String> pubIdsForLocations = pubRefs.stream().map(WAPrimaryKey::getId).collect(Collectors.toSet());
            this.locationsByPublicationCache = this.publicationService.getAllLocationsByPublicationIds(pubIdsForLocations);
            Set<String> additionalInstanceIdsToLoad = this.locationsByPublicationCache.entrySet().stream().flatMap(e -> new ArrayList((Collection)e.getValue()).stream()).map(WAPrimaryKey::getInstanceId).filter(i -> !instanceIds.contains(i)).collect(Collectors.toSet());
            if (!additionalInstanceIdsToLoad.isEmpty()) {
                nodeDataManager.completeCaches(userId, additionalInstanceIdsToLoad);
            }
            return this;
        }

        private void loadPublicationCacheByPks(Collection<PublicationPK> pks) {
            if (this.givenPublicationPks != null) {
                return;
            }
            this.givenPublicationPks = pks.stream().map(PubInAppInstanceRef::new).distinct().collect(Collectors.toList());
            if (AccessControlOperation.isSearchActionFrom(this.operations)) {
                this.publicationCache = Collections.emptyMap();
            } else {
                List<PublicationDetail> publications = this.publicationService.getMinimalDataByIds(this.givenPublicationPks);
                this.loadPublicationCloneCache(publications);
            }
        }

        private void loadPublicationCacheByDetails(Collection<PublicationDetail> pubs) {
            if (this.givenPublicationPks != null) {
                return;
            }
            this.givenPublicationPks = pubs.stream().map(PublicationDetail::getPK).map(PubInAppInstanceRef::new).distinct().collect(Collectors.toList());
            if (AccessControlOperation.isSearchActionFrom(this.operations)) {
                this.publicationCache = Collections.emptyMap();
            } else {
                this.loadPublicationCloneCache(pubs);
            }
        }

        private void loadPublicationCloneCache(Collection<PublicationDetail> publications) {
            List<PublicationPK> masterPubPks = publications.stream().filter(DataManager::isItAClone).map(PublicationDetail::getClonePK).collect(Collectors.toList());
            List<Object> masterPubs = masterPubPks.isEmpty() ? Collections.emptyList() : this.publicationService.getMinimalDataByIds(masterPubPks);
            int cacheSize = publications.size() + masterPubs.size();
            this.publicationCache = new HashMap<PublicationPK, PublicationDetail>(cacheSize);
            Consumer<PublicationDetail> cacheSupplier = p -> this.publicationCache.put(new PubInAppInstanceRef(p.getPK()), (PublicationDetail)p);
            publications.forEach(cacheSupplier);
            masterPubs.forEach(cacheSupplier);
        }

        PublicationPK prepareCheckFor(PublicationPK pubPK) {
            this.allLocations = null;
            this.lastMainLocation = null;
            this.lastPublicationDetail = null;
            return pubPK;
        }

        List<PublicationPK> getGivenPublicationPks() {
            return this.givenPublicationPks;
        }

        boolean isLotOfDataMode() {
            return this.lotOfDataMode;
        }

        Supplier<Optional<Location>> getPublicationMainLocationSupplier(PublicationPK pk) {
            if (this.lastMainLocation == null) {
                this.lastMainLocation = new MemoizedSupplier(() -> this.getAllLocations(pk).get().stream().filter(l -> !l.isAlias()).findFirst());
            }
            return this.lastMainLocation;
        }

        List<Location> getAllPublicationAliases(PublicationPK pk) {
            return this.getAllLocations(pk).get().stream().filter(Location::isAlias).collect(Collectors.toList());
        }

        private Supplier<List<Location>> getAllLocations(PublicationPK pk) {
            if (this.allLocations == null) {
                this.allLocations = new MemoizedSupplier(() -> {
                    PublicationPK masterPk = Optional.ofNullable(this.getCurrentPublication()).filter(Predicate.not(DataManager::isItAClone).and(PublicationDetail::haveGotClone).and(p -> Objects.equals(p.getClonePK(), pk))).map(PublicationDetail::getPK).orElse(pk);
                    if (this.locationsByPublicationCache != null) {
                        return this.locationsByPublicationCache.getOrDefault(masterPk.getId(), Collections.emptyList());
                    }
                    return this.publicationService.getAllLocations(masterPk);
                });
            }
            return this.allLocations;
        }

        PublicationDetail getCurrentPublication() {
            return this.lastPublicationDetail;
        }

        DataManager loadPublication(PublicationPK pk) {
            if (this.lastPublicationDetail == null || !this.lastPublicationDetail.getPK().equals(pk)) {
                PublicationDetail pubDetail = null;
                try {
                    pubDetail = this.getPublicationData(pk);
                    if (DataManager.isItAClone(pubDetail)) {
                        pubDetail = this.getPublicationData(pubDetail.getClonePK());
                    }
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).warn((Throwable)e);
                }
                this.lastPublicationDetail = pubDetail;
            }
            return this;
        }

        private PublicationDetail getPublicationData(PublicationPK pk) {
            if (this.publicationCache != null) {
                return this.publicationCache.get(new PubInAppInstanceRef(pk));
            }
            return this.publicationService.getMinimalDataByIds(Collections.singleton(pk)).stream().findFirst().orElse(null);
        }

        private static boolean isItAClone(PublicationDetail pubDetail) {
            return pubDetail != null && !pubDetail.isValid() && pubDetail.haveGotClone() && pubDetail.isClone();
        }
    }

    private static class PubInAppInstanceRef
    extends PublicationPK {
        public PubInAppInstanceRef(PublicationPK pk) {
            super(pk.getLocalId(), pk);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof PublicationPK) {
                PublicationPK other = (PublicationPK)obj;
                return Objects.equals(this.getLocalId(), other.getLocalId()) && Objects.equals(this.getInstanceId(), other.getInstanceId());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getLocalId(), this.getInstanceId());
        }
    }
}

