/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.verifier;

import java.util.MissingResourceException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.service.UserProvider;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

class AbstractAuthenticationVerifier {
    protected static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.authentication.settings.authenticationSettings");
    protected static final SettingBundle otherSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.authentication.settings.passwordExpiration");
    private static final String CACHE_KEY_PREFIX = AbstractAuthenticationVerifier.class.getSimpleName() + "_userByLoginDomain_";
    private User user;

    protected AbstractAuthenticationVerifier(User user) {
        this.user = user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    @Nullable
    static User getUserByCredential(@Nullable AuthenticationCredential credential) {
        if (credential == null) {
            return null;
        }
        String cacheKey = AbstractAuthenticationVerifier.cacheKey(credential.getLogin(), credential.getDomainId());
        return (User)CacheAccessorProvider.getThreadCacheAccessor().getCache().computeIfAbsent((Object)cacheKey, User.class, () -> {
            User user = UserProvider.get().getUserByLoginAndDomainId(credential.getLogin(), credential.getDomainId());
            return Optional.ofNullable(user).filter(u -> credential.loginIgnoreCase() ? u.getLogin().equalsIgnoreCase(credential.getLogin()) : u.getLogin().equals(credential.getLogin())).orElse(null);
        });
    }

    static void removeFromRequestCache(User user) {
        if (user != null) {
            String cacheKey = AbstractAuthenticationVerifier.cacheKey(user.getLogin(), user.getDomainId());
            CacheAccessorProvider.getThreadCacheAccessor().getCache().remove((Object)cacheKey);
        }
    }

    protected static UserDetail getUserById(String userId) {
        return UserDetail.getById(userId);
    }

    protected static String getString(String key, String language, String ... params) {
        String translation;
        LocalizationBundle messages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.authentication.multilang.authentication", (String)language);
        try {
            translation = params != null && params.length > 0 ? messages.getStringWithParams(key, (Object[])params) : messages.getString(key);
        }
        catch (MissingResourceException ex) {
            translation = "";
        }
        return translation;
    }

    private static String cacheKey(String login, String domainId) {
        return CACHE_KEY_PREFIX + login + "@domain" + domainId;
    }
}

