/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.password.service;

import java.util.ArrayList;
import java.util.Collection;
import org.silverpeas.core.security.authentication.password.PasswordBundle;
import org.silverpeas.core.security.authentication.password.rule.PasswordRule;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

public class PasswordCheck {
    protected static SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.password.settings.password");
    private final Collection<PasswordRule> requiredRulesInError = new ArrayList<PasswordRule>();
    private final Collection<PasswordRule> combinedRules;
    private final Collection<PasswordRule> combinedRulesInError = new ArrayList<PasswordRule>();
    private final int nbMatchingCombinedRules;
    private final int nbCombinedErrorsAuthorized;
    private String id;

    PasswordCheck(Collection<PasswordRule> combinedRules, int nbMatchingCombinedRules) {
        this.combinedRules = combinedRules;
        this.nbMatchingCombinedRules = nbMatchingCombinedRules;
        this.nbCombinedErrorsAuthorized = combinedRules.size() - nbMatchingCombinedRules;
    }

    void addRequiredError(PasswordRule rule) {
        this.requiredRulesInError.add(rule);
    }

    void addCombinedError(PasswordRule rule) {
        this.combinedRulesInError.add(rule);
    }

    void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Collection<PasswordRule> getRequiredRulesInError() {
        return this.requiredRulesInError;
    }

    public Collection<PasswordRule> getCombinedRulesInError() {
        return this.combinedRulesInError;
    }

    public boolean isCorrect() {
        return this.requiredRulesInError.isEmpty() && this.isRuleCombinationRespected();
    }

    public boolean isRuleCombinationRespected() {
        return this.combinedRulesInError.isEmpty() || this.combinedRulesInError.size() <= this.nbCombinedErrorsAuthorized;
    }

    public String getFormattedErrorMessage(String language) {
        StringBuilder errorMessage = new StringBuilder();
        if (!this.requiredRulesInError.isEmpty()) {
            errorMessage.append(this.getString("password.checking.error.message", language, this.getFormattedPasswordListMessage(this.requiredRulesInError, language)));
        }
        if (!this.combinedRulesInError.isEmpty()) {
            if (errorMessage.length() > 0) {
                errorMessage.append(". ");
            }
            errorMessage.append(this.getString("password.checking.combined.error.message", language, String.valueOf(this.nbMatchingCombinedRules), this.getFormattedPasswordListMessage(this.combinedRules, language)));
        }
        return errorMessage.toString();
    }

    private String getFormattedPasswordListMessage(Collection<PasswordRule> rules, String language) {
        StringBuilder formattedMessage = new StringBuilder();
        for (PasswordRule rule : rules) {
            if (formattedMessage.length() > 0) {
                formattedMessage.append(", ");
            }
            formattedMessage.append(rule.getDescription(language));
        }
        return formattedMessage.toString();
    }

    protected String getString(String key, String language, String ... params) {
        PasswordBundle bundle = new PasswordBundle(language);
        return bundle.getString(key, params);
    }
}

