/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.password.rule;

import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.silverpeas.core.security.authentication.password.PasswordBundle;
import org.silverpeas.core.security.authentication.password.constant.PasswordRuleType;
import org.silverpeas.core.security.authentication.password.rule.PasswordRule;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractPasswordRule
implements PasswordRule {
    protected static final int DEFAULT_LENGTH = 8;
    protected static SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.password.settings.password");
    private final PasswordRuleType passwordRuleType;
    private final Random random = new Random();

    protected AbstractPasswordRule(PasswordRuleType passwordRuleType) {
        this.passwordRuleType = passwordRuleType;
    }

    @Override
    public PasswordRuleType getType() {
        return this.passwordRuleType;
    }

    @Override
    public String getDescription(String language) {
        Object value = this.getValue();
        String param = value instanceof Boolean ? null : String.valueOf(value);
        return this.getString(this.getType().getBundleKey(), language, param);
    }

    @Override
    public boolean isRequired() {
        Object value = this.getValue();
        if (value instanceof String) {
            return StringUtil.isDefined((String)((String)value));
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() > 0.0;
        }
        return value != null;
    }

    @Override
    public boolean isCombined() {
        return false;
    }

    protected int random(int maxValue) {
        return (int)((double)maxValue * this.random.nextDouble());
    }

    protected String getString(String key, String language, String ... params) {
        PasswordBundle bundle = new PasswordBundle(language);
        return bundle.getString(key, params);
    }

    protected Integer getIntegerFromSettings(String key, Integer defaultValue) {
        Integer value = defaultValue;
        try {
            value = settings.getInteger(key, defaultValue.intValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value >= 0 ? value : 0;
    }

    protected int countRegexOccur(String text, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(text);
        int occur = 0;
        while (matcher.find()) {
            ++occur;
        }
        return occur;
    }
}

