/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.scheduler.quartz;

import javax.enterprise.inject.Default;
import javax.inject.Singleton;
import org.quartz.JobDetail;
import org.quartz.JobExecutionException;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.quartz.JobExecutor;
import org.silverpeas.core.scheduler.quartz.QuartzScheduler;

@Default
@Service
@Singleton
public class VolatileQuartScheduler
extends QuartzScheduler {
    protected VolatileQuartScheduler() {
    }

    public void init() {
        this.setUpQuartzScheduler(null);
    }

    public void release() throws SchedulerException {
        this.shutdown();
    }

    protected Job encodeJob(Job job) {
        return job;
    }

    protected SchedulerEventListener encodeEventListener(SchedulerEventListener listener) {
        return listener;
    }

    protected Class<VolatileJobExecutor> getJobExecutor() {
        return VolatileJobExecutor.class;
    }

    @Override
    protected <T> void execute(QuartzScheduler.SchedulingTask<T> schedulingTask) throws org.quartz.SchedulerException {
        schedulingTask.execute();
    }

    public static class VolatileJobExecutor
    extends JobExecutor {
        @Override
        protected Job getJob(JobDetail jobDetail) throws JobExecutionException {
            try {
                return (Job)jobDetail.getJobDataMap().get((Object)"job");
            }
            catch (ClassCastException e) {
                throw new JobExecutionException((Throwable)e);
            }
        }

        @Override
        protected SchedulerEventListener getSchedulerEventListener(JobDetail jobDetail) throws JobExecutionException {
            try {
                return (SchedulerEventListener)jobDetail.getJobDataMap().get((Object)"listener");
            }
            catch (ClassCastException e) {
                throw new JobExecutionException((Throwable)e);
            }
        }
    }
}

