/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.scheduler.quartz;

import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.silverpeas.core.scheduler.quartz.QuartzCronExpression;
import org.silverpeas.core.scheduler.trigger.CronJobTrigger;
import org.silverpeas.core.scheduler.trigger.FixedDateTimeJobTrigger;
import org.silverpeas.core.scheduler.trigger.FixedPeriodJobTrigger;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.scheduler.trigger.JobTriggerVisitor;

public final class QuartzTriggerBuilder
implements JobTriggerVisitor {
    private Trigger quartzTrigger = null;
    private final String jobName;

    public static QuartzTriggerBuilder forJob(String jobName) {
        return new QuartzTriggerBuilder(jobName);
    }

    public Trigger buildFrom(JobTrigger jobTrigger) {
        jobTrigger.accept((JobTriggerVisitor)this);
        return this.quartzTrigger;
    }

    public void visit(FixedPeriodJobTrigger trigger) {
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(this.jobName);
        switch (trigger.getTimeUnit()) {
            case SECOND: {
                triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(trigger.getTimeInterval()).repeatForever());
                break;
            }
            case MINUTE: {
                triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(trigger.getTimeInterval()).repeatForever());
                break;
            }
            case HOUR: {
                triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(trigger.getTimeInterval()).repeatForever());
                break;
            }
        }
        if (trigger.getStartDate() != null) {
            triggerBuilder.startAt(trigger.getStartDate());
        } else {
            triggerBuilder.startNow();
        }
        this.quartzTrigger = triggerBuilder.forJob(this.jobName).build();
    }

    public void visit(CronJobTrigger trigger) {
        QuartzCronExpression cronExpression = (QuartzCronExpression)trigger.getCronExpression();
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(this.jobName).forJob(this.jobName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cronExpression.getExpression()));
        if (trigger.getStartDate() != null) {
            triggerBuilder.startAt(trigger.getStartDate());
        }
        this.quartzTrigger = triggerBuilder.build();
    }

    public void visit(FixedDateTimeJobTrigger trigger) {
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(this.jobName).forJob(this.jobName).startAt(trigger.getStartDate());
        this.quartzTrigger = triggerBuilder.build();
    }

    private QuartzTriggerBuilder(String jobName) {
        this.jobName = jobName;
    }
}

