/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.scheduler.quartz;

import java.lang.reflect.InvocationTargetException;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.Optional;
import javax.annotation.PreDestroy;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.scheduler.EmptyJob;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.ScheduledJob;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.quartz.JobExecutor;
import org.silverpeas.core.scheduler.quartz.QuartzScheduledJob;
import org.silverpeas.core.scheduler.quartz.QuartzSchedulerException;
import org.silverpeas.core.scheduler.quartz.QuartzTriggerBuilder;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.util.ArgumentAssertion;
import org.silverpeas.core.util.Process;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class QuartzScheduler
implements Scheduler,
Initialization {
    static final String ACTUAL_JOB = "job";
    static final String JOB_LISTENER = "listener";
    static final String JOB_SCHEDULED = "scheduled";
    private org.quartz.Scheduler quartz;

    protected QuartzScheduler() {
    }

    public int getPriority() {
        return 0;
    }

    final void setUpQuartzScheduler(String quartzProperties) {
        try {
            StdSchedulerFactory quartzSchedulerFactory = new StdSchedulerFactory();
            if (StringUtil.isDefined((String)quartzProperties)) {
                quartzSchedulerFactory.initialize(ResourceLocator.getSettingsAsProperties((String)quartzProperties));
            }
            this.quartz = quartzSchedulerFactory.getScheduler();
            if (!this.quartz.isStarted()) {
                this.quartz.start();
            }
        }
        catch (org.quartz.SchedulerException ex) {
            SilverLogger.getLogger((Object)this).error("Quartz Scheduler failed to start!", (Throwable)ex);
            throw new QuartzSchedulerException(ex.getMessage(), ex);
        }
    }

    protected abstract Object encodeJob(Job var1);

    protected abstract Object encodeEventListener(SchedulerEventListener var1);

    protected abstract <T extends JobExecutor> Class<T> getJobExecutor();

    private JobDetail buildJobDetail(Job job, SchedulerEventListener listener) {
        JobDetail jobDetail = JobBuilder.newJob(this.getJobExecutor()).withIdentity(job.getName()).build();
        jobDetail.getJobDataMap().put(ACTUAL_JOB, this.encodeJob(job));
        if (listener != null) {
            jobDetail.getJobDataMap().put(JOB_LISTENER, this.encodeEventListener(listener));
        }
        return jobDetail;
    }

    protected abstract <T> void execute(SchedulingTask<T> var1) throws org.quartz.SchedulerException;

    private void fireNow(Date expectedFireTime, Job job, SchedulerEventListener listener) throws org.quartz.SchedulerException {
        JobExecutor executor;
        Date fireTime = expectedFireTime;
        if (fireTime == null) {
            fireTime = new Date();
        }
        Class jobExecutorClass = this.getJobExecutor();
        try {
            executor = (JobExecutor)jobExecutorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new org.quartz.SchedulerException(e.getMessage(), (Throwable)e);
        }
        JobExecutionContext context = JobExecutionContext.createWith((String)job.getName(), (Date)fireTime);
        executor.execute(context, job, listener);
    }

    public ScheduledJob scheduleJob(String jobName, JobTrigger trigger, SchedulerEventListener listener) throws SchedulerException {
        QuartzScheduler.checkArguments(jobName, trigger, listener);
        return this.scheduleJob(new EmptyJob(jobName), trigger, listener);
    }

    public ScheduledJob scheduleJob(Job theJob, JobTrigger jobTrigger, SchedulerEventListener listener) throws SchedulerException {
        QuartzScheduler.checkArguments(theJob, jobTrigger);
        Trigger quartzTrigger = QuartzTriggerBuilder.forJob(theJob.getName()).buildFrom(jobTrigger);
        JobDetail jobDetail = this.buildJobDetail(theJob, listener);
        try {
            if (this.isInPast(quartzTrigger)) {
                this.fireNow(quartzTrigger.getFinalFireTime(), theJob, listener);
            } else {
                jobDetail.getJobDataMap().put(JOB_SCHEDULED, true);
                this.execute(() -> this.quartz.scheduleJob(jobDetail, quartzTrigger));
            }
            return new QuartzScheduledJob(quartzTrigger);
        }
        catch (org.quartz.SchedulerException ex) {
            SilverLogger.getLogger((Object)this).error("The scheduling of the job ''{0}'' failed!", (Object[])new String[]{theJob.getName()}, (Throwable)ex);
            throw new SchedulerException(ex.getMessage(), (Throwable)ex);
        }
    }

    public ScheduledJob scheduleJob(Job theJob, JobTrigger trigger) throws SchedulerException {
        return this.scheduleJob(theJob, trigger, null);
    }

    public void unscheduleJob(String jobName) throws SchedulerException {
        QuartzScheduler.checkJobName(jobName);
        try {
            this.execute(() -> this.quartz.deleteJob(JobKey.jobKey((String)jobName)));
        }
        catch (org.quartz.SchedulerException ex) {
            SilverLogger.getLogger((Object)this).error("The unscheduling of the job ''{0}'' failed!", (Object[])new String[]{jobName}, (Throwable)ex);
            throw new SchedulerException(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean isJobScheduled(String jobName) {
        QuartzScheduler.checkJobName(jobName);
        try {
            JobDetail jobDetail = this.quartz.getJobDetail(JobKey.jobKey((String)jobName));
            boolean isScheduled = false;
            if (jobDetail != null) {
                isScheduled = jobDetail.getJobDataMap().getBoolean(JOB_SCHEDULED);
            }
            return isScheduled;
        }
        catch (org.quartz.SchedulerException e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
            return false;
        }
    }

    public Optional<ScheduledJob> getScheduledJob(String jobName) {
        QuartzScheduler.checkJobName(jobName);
        try {
            Trigger trigger = this.quartz.getTrigger(TriggerKey.triggerKey((String)jobName));
            return Optional.of(new QuartzScheduledJob(trigger));
        }
        catch (org.quartz.SchedulerException e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
            return Optional.empty();
        }
    }

    public void shutdown() throws SchedulerException {
        try {
            if (!this.quartz.isShutdown()) {
                this.quartz.shutdown();
            }
        }
        catch (org.quartz.SchedulerException ex) {
            SilverLogger.getLogger((Object)this).error("The scheduler shutdown failed!", (Throwable)ex);
            throw new SchedulerException(ex.getMessage(), (Throwable)ex);
        }
    }

    @PreDestroy
    private void shutdownBeforeRelease() {
        try {
            this.shutdown();
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    private boolean isInPast(Trigger trigger) {
        return !trigger.mayFireAgain() && trigger.getFinalFireTime() != null && trigger.getFinalFireTime().before(Date.from(OffsetDateTime.now().toInstant()));
    }

    private static void checkArguments(String jobName, JobTrigger trigger, SchedulerEventListener listener) {
        QuartzScheduler.checkJobName(jobName);
        QuartzScheduler.checkJobTrigger(trigger);
        ArgumentAssertion.assertNotNull((Object)listener, (String)"The scheduler event listener shouldn't be null");
    }

    private static void checkArguments(Job job, JobTrigger trigger) {
        ArgumentAssertion.assertNotNull((Object)job, (String)"The job should not be null");
        QuartzScheduler.checkJobTrigger(trigger);
    }

    private static void checkJobName(String jobName) {
        ArgumentAssertion.assertDefined((String)jobName, (String)"The job name should be defined");
    }

    private static void checkJobTrigger(JobTrigger trigger) {
        ArgumentAssertion.assertNotNull((Object)trigger, (String)"The job trigger shouldn't be null");
    }

    protected static interface SchedulingTask<T>
    extends Process<T> {
        public T execute() throws org.quartz.SchedulerException;
    }
}

