/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.process.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.silverpeas.core.process.SilverpeasProcess;
import org.silverpeas.core.process.check.ProcessCheckType;
import org.silverpeas.core.process.management.ProcessErrorType;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.process.session.DefaultProcessSession;
import org.silverpeas.core.process.session.ProcessSession;

class InternalContext<C extends ProcessExecutionContext> {
    private final InternalContext<? extends ProcessExecutionContext> previous;
    private InternalContext<? extends ProcessExecutionContext> next;
    private final C processExecutionContext;
    private ProcessSession session;
    private final List<SilverpeasProcess<C>> startedProcesses = new ArrayList<SilverpeasProcess<C>>();
    private final Set<ProcessCheckType> checkTypesToProcess = new HashSet<ProcessCheckType>();
    private boolean isFileTransactionInError = false;
    private SilverpeasProcess<?> processInError = null;
    private ProcessErrorType errorType = null;
    private Exception exception = null;

    protected InternalContext(C processExecutionContext) {
        this.processExecutionContext = processExecutionContext;
        this.session = DefaultProcessSession.create();
        this.previous = null;
    }

    protected InternalContext(InternalContext<? extends ProcessExecutionContext> previous, C processExecutionContext) {
        this.processExecutionContext = processExecutionContext;
        this.previous = previous;
        this.previous.next = this;
        this.session = previous.session;
        ((ProcessExecutionContext)processExecutionContext).setFileHandler(previous.getProcessExecutionContext().getFileHandler());
    }

    protected C getProcessExecutionContext() {
        return this.processExecutionContext;
    }

    protected ProcessSession getSession() {
        return this.session;
    }

    public void setSession(ProcessSession session) {
        this.session = session;
    }

    protected void setFileTransactionInError(ProcessErrorType errorType, Exception exception, SilverpeasProcess<?> processInError) {
        for (InternalContext<ProcessExecutionContext> context = this; context != null; context = context.getPrevious()) {
            context.isFileTransactionInError = true;
            context.processInError = processInError;
            context.errorType = errorType;
            context.exception = exception;
        }
    }

    protected boolean isFileTransactionInError() {
        return this.isFileTransactionInError;
    }

    protected SilverpeasProcess<?> getProcessInError() {
        return this.processInError;
    }

    protected ProcessErrorType getErrorType() {
        return this.errorType;
    }

    protected Exception getException() {
        return this.exception;
    }

    protected void update(SilverpeasProcess<C> process) {
        this.startedProcesses.add(process);
        this.getFirst().checkTypesToProcess.addAll(process.getProcessType().getCheckTypesToProcess());
    }

    protected Set<ProcessCheckType> getCheckTypesToProcess() {
        return this.checkTypesToProcess;
    }

    protected List<SilverpeasProcess<C>> getOnSuccessfulProcesses() {
        return this.startedProcesses;
    }

    protected List<SilverpeasProcess<C>> getOnFailureProcesses() {
        Collections.reverse(this.startedProcesses);
        return this.startedProcesses;
    }

    protected boolean isOpeningFileTransaction() {
        return this.previous == null;
    }

    protected InternalContext<? extends ProcessExecutionContext> getPrevious() {
        return this.previous;
    }

    protected InternalContext<? extends ProcessExecutionContext> getNext() {
        return this.next;
    }

    protected InternalContext<? extends ProcessExecutionContext> getFirst() {
        for (InternalContext<? extends ProcessExecutionContext> parent = this.previous; parent != null; parent = parent.getPrevious()) {
            if (parent.getPrevious() != null) {
                continue;
            }
            return parent;
        }
        return this;
    }

    protected InternalContext<? extends ProcessExecutionContext> getLast() {
        for (InternalContext<? extends ProcessExecutionContext> child = this.next; child != null; child = child.getNext()) {
            if (child.getNext() != null) {
                continue;
            }
            return child;
        }
        return this;
    }
}

