/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mail;

import java.util.stream.Stream;
import javax.mail.Multipart;
import org.silverpeas.core.mail.MailAddress;
import org.silverpeas.core.mail.MailContent;
import org.silverpeas.core.mail.MailToSend;
import org.silverpeas.core.mail.ReceiverMailAddressSet;
import org.silverpeas.core.mail.engine.MailSenderTask;

public class MailSending {
    private MailToSend mailToSend;
    private boolean separately = false;

    public static MailSending from(MailAddress senderEmail) {
        MailSending mailSending = new MailSending();
        mailSending.mailToSend = new MailToSend();
        mailSending.mailToSend.setFrom(senderEmail);
        return mailSending;
    }

    private MailSending() {
    }

    public MailSending to(MailAddress receiverMailAddress) {
        this.mailToSend.setTo(ReceiverMailAddressSet.with(receiverMailAddress));
        return this;
    }

    public MailSending to(ReceiverMailAddressSet receiverMailAddressSet) {
        this.mailToSend.setTo(receiverMailAddressSet);
        return this;
    }

    public MailSending withSubject(String subject) {
        this.mailToSend.setSubject(subject);
        return this;
    }

    public MailSending withContent(String content) {
        this.mailToSend.setContent(MailContent.of(content));
        return this;
    }

    public MailSending withTextContent(String content) {
        this.mailToSend.setContent(MailContent.of(content).notHtml());
        return this;
    }

    public MailSending withContent(Multipart content) {
        this.mailToSend.setContent(MailContent.of(content));
        return this;
    }

    public MailSending withContent(MailContent content) {
        this.mailToSend.setContent(content);
        return this;
    }

    public MailSending setReplyToRequired() {
        this.mailToSend.setReplyToRequired();
        return this;
    }

    public MailSending oneMailPerReceiver() {
        this.separately = true;
        return this;
    }

    MailToSend getMailToSend() {
        return this.mailToSend;
    }

    public void send() {
        (this.separately ? this.byReceivers() : Stream.of(this.mailToSend)).forEach(MailSenderTask::addMailToSend);
    }

    public void sendSynchronously() {
        this.mailToSend.sendSynchronously();
        this.send();
    }

    private Stream<MailToSend> byReceivers() {
        return this.mailToSend.getTo().stream().map(r -> {
            MailToSend copy = new MailToSend();
            copy.setFrom(this.mailToSend.getFrom());
            copy.setTo(ReceiverMailAddressSet.with(r));
            copy.setSubject(this.mailToSend.getSubject());
            copy.setContent(this.mailToSend.getContent());
            if (this.mailToSend.isReplyToRequired()) {
                copy.setReplyToRequired();
            }
            if (!this.mailToSend.isAsynchronous()) {
                copy.sendSynchronously();
            }
            return copy;
        });
    }
}

