/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.model;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.util.ElisionFilter;
import org.silverpeas.core.i18n.I18n;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

public final class WAAnalyzer
extends Analyzer {
    private static final int LANGUAGE_CODE_LENGTH = 2;
    private static final Map<String, WAAnalyzer> languageMap = new ConcurrentHashMap<String, WAAnalyzer>();
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.index.indexing.IndexEngine");
    private String stemmer = null;
    private boolean snowballUsed = false;
    private final String language;

    private WAAnalyzer(String lang) {
        this.language = lang;
        this.stemmer = this.getStemmer();
        this.snowballUsed = settings.getBoolean("snowball.active", false);
    }

    public static Analyzer getAnalyzer(String language) {
        return Optional.ofNullable(languageMap.get(language)).orElseGet(() -> {
            String computedLanguage = Optional.ofNullable(language).filter(l -> l.length() == 2).orElseGet(() -> settings.getString("analyzer.language.default", I18n.get().getDefaultLanguage()));
            WAAnalyzer analyzer = languageMap.computeIfAbsent(computedLanguage, WAAnalyzer::new);
            return languageMap.computeIfAbsent(language, l -> analyzer);
        });
    }

    protected Analyzer.TokenStreamComponents createComponents(String s) {
        StandardTokenizer source = new StandardTokenizer();
        LowerCaseFilter result = new LowerCaseFilter((TokenStream)source);
        result = new StopFilter((TokenStream)result, FrenchAnalyzer.getDefaultStopSet());
        result = new ElisionFilter((TokenStream)result, FrenchAnalyzer.DEFAULT_ARTICLES);
        if (this.snowballUsed) {
            result = new SnowballFilter((TokenStream)result, this.stemmer);
        }
        result = new ASCIIFoldingFilter((TokenStream)result);
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }

    private String getStemmer() {
        return settings.getString("snowball.stemmer." + this.language, "French");
    }

    public String getLanguage() {
        return this.language;
    }
}

