/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.ical;

import java.io.Writer;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.importexport.ExportDescriptor;
import org.silverpeas.core.importexport.ExportException;
import org.silverpeas.core.importexport.Exporter;
import org.silverpeas.core.importexport.NoDataToExportException;
import org.silverpeas.core.importexport.ical.ExportableCalendar;
import org.silverpeas.core.importexport.ical.ICalCodec;
import org.silverpeas.kernel.logging.SilverLogger;

@Singleton
public class ICalExporter
implements Exporter<ExportableCalendar> {
    private final ICalCodec iCalCodec;

    @Inject
    private ICalExporter(ICalCodec iCalCodec) {
        this.iCalCodec = iCalCodec;
    }

    protected ICalCodec getICalCodec() {
        return this.iCalCodec;
    }

    public void exports(ExportDescriptor descriptor, Supplier<ExportableCalendar> supplier) throws ExportException {
        ExportableCalendar calendar = supplier.get();
        if (calendar.isEmpty()) {
            throw new NoDataToExportException("To export to iCal, the calendar should have at least one event");
        }
        Writer writer = descriptor.getWriter();
        try {
            String iCalCalendar = this.getICalCodec().encode(calendar.getEvents());
            writer.write(iCalCalendar);
            writer.close();
        }
        catch (Exception e) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception ex) {
                SilverLogger.getLogger((Object)this).error((Throwable)ex);
            }
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            throw new ExportException(e.getMessage(), (Throwable)e);
        }
    }
}

