/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.i18n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.i18n.BeanTranslation;
import org.silverpeas.core.i18n.I18NBean;
import org.silverpeas.core.i18n.I18NLanguage;
import org.silverpeas.core.i18n.I18n;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.MultiSilverpeasBundle;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

@Technical
@Service
@Singleton
public class I18NHelper
implements I18n {
    private static final Map<String, List<I18NLanguage>> allContentLanguages;
    private static final Map<String, List<I18NLanguage>> fallbackContentLanguages;
    private static int nbContentLanguages;
    public static final boolean isI18nContentActivated;
    public static final String DEFAULT_LANGUAGE;
    public static final Locale defaultLocale;
    private static final List<String> allContentLanguageCodes;
    public static final String HTMLSelectObjectName = "I18NLanguage";
    public static final String HTMLHiddenRemovedTranslationMode = "TranslationRemoveIt";

    public static String getLanguageLabel(String code, String userLanguage) {
        List<I18NLanguage> labels = I18NHelper.getAllUserTranslationsOfContentLanguages(userLanguage);
        for (I18NLanguage language : labels) {
            if (!language.getCode().equalsIgnoreCase(code)) continue;
            return language.getLabel();
        }
        return "";
    }

    public static List<I18NLanguage> getAllUserTranslationsOfContentLanguages(String userLanguage) {
        List<I18NLanguage> allContentLanguageUserTranslations = allContentLanguages.get(userLanguage);
        if (allContentLanguageUserTranslations == null) {
            allContentLanguageUserTranslations = fallbackContentLanguages.get(userLanguage);
        }
        return allContentLanguageUserTranslations;
    }

    public static Collection<String> getLanguages() {
        return Collections.unmodifiableSet(allContentLanguages.keySet());
    }

    public String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    public Set<String> getSupportedLanguages() {
        return I18NHelper.getAllSupportedLanguages();
    }

    public static Set<String> getAllSupportedLanguages() {
        return allContentLanguages.keySet();
    }

    public static int getNumberOfLanguages() {
        return allContentLanguages.size();
    }

    public static boolean isDefaultLanguage(String language) {
        if (StringUtil.isDefined((String)language)) {
            return DEFAULT_LANGUAGE.equalsIgnoreCase(language);
        }
        return true;
    }

    public static String checkLanguage(String language) {
        String lang = language;
        if (!StringUtil.isDefined((String)language) || !allContentLanguageCodes.contains(language)) {
            lang = DEFAULT_LANGUAGE;
        }
        return lang;
    }

    public static String getHTMLLinks(String url, String currentLanguage) {
        if (!isI18nContentActivated) {
            return "";
        }
        Object baseUrl = url;
        baseUrl = url.contains("?") ? (String)baseUrl + "&SwitchLanguage=" : (String)baseUrl + "?SwitchLanguage=";
        StringBuilder links = new StringBuilder(512);
        boolean first = true;
        for (String code : allContentLanguageCodes) {
            String className = "";
            String link = (String)baseUrl + code;
            if (!first) {
                links.append("&nbsp;");
            }
            if (code.equals(currentLanguage)) {
                className = "ArrayNavigationOn";
            }
            links.append("<a href=\"").append(link).append("\" class=\"").append(className).append("\" id=\"translation_").append(code).append("\">").append(code.toUpperCase(defaultLocale)).append("</a>");
            first = false;
        }
        return links.toString();
    }

    public static String getHTMLLinks(List<String> languages, String currentLanguage) {
        if (!isI18nContentActivated || languages == null) {
            return "";
        }
        StringBuilder links = new StringBuilder(512);
        boolean first = true;
        for (String code : allContentLanguageCodes) {
            String className = "";
            if (!languages.contains(code)) continue;
            String link = "javaScript:showTranslation('" + code + "');";
            if (!first) {
                links.append("&nbsp;");
            }
            if (code.equals(currentLanguage) || languages.size() == 1) {
                className = "ArrayNavigationOn";
            }
            links.append("<a href=\"").append(link).append("\" class=\"").append(className).append("\" id=\"translation_").append(code).append("\">").append(code.toUpperCase(defaultLocale)).append("</a>");
            first = false;
        }
        return links.toString();
    }

    public static String getHTMLLinks(I18NBean<?> bean, String currentLanguage) {
        Object translation;
        String lang = currentLanguage;
        if (!isI18nContentActivated || bean == null) {
            return "";
        }
        if (bean.getTranslations().get(lang) == null && (translation = bean.getNextTranslation()) != null) {
            lang = translation.getLanguage();
        }
        ArrayList<String> languages = new ArrayList<String>(bean.getTranslations().keySet());
        return I18NHelper.getHTMLLinks(languages, lang);
    }

    public static String getFormLine(MultiSilverpeasBundle resources) {
        return I18NHelper.getFormLine(resources, null, null);
    }

    public static String getFormLine(MultiSilverpeasBundle resources, I18NBean<?> bean, String translation) {
        if (nbContentLanguages == 1) {
            return "";
        }
        return "<tr>\n<td class=\"txtlibform\">" + resources.getString("GML.language") + " :</td>\n<td>" + I18NHelper.getHTMLSelectObject(resources.getLanguage(), bean, translation) + "</td></tr>\n";
    }

    public static String getHTMLSelectObject(String userLanguage, I18NBean<?> bean, String selectedTranslation) {
        List<I18NLanguage> languages = I18NHelper.getAllUserTranslationsOfContentLanguages(userLanguage);
        ArrayList<I18NLanguage> result = new ArrayList<I18NLanguage>();
        for (I18NLanguage lang : languages) {
            BeanTranslation translation;
            I18NLanguage newLang = new I18NLanguage(lang.getCode(), lang.getLabel());
            if (bean != null && (translation = (BeanTranslation)bean.getTranslations().get(newLang.getCode())) != null) {
                newLang.setTranslationId(translation.getId());
            }
            result.add(newLang);
        }
        return I18NHelper.getHTMLSelectObject(result, bean, selectedTranslation, userLanguage);
    }

    private static String getHTMLSelectObject(List<I18NLanguage> toDisplay, I18NBean<?> bean, String selectedTranslation, String userLanguage) {
        StringBuilder list = new StringBuilder();
        String currentTranslation = selectedTranslation;
        String onChangeJavascript = "";
        if (bean != null) {
            Object translation;
            onChangeJavascript = "onChange= \"javaScript:showTranslation(this.value.substring(0,2));\"";
            if ((currentTranslation == null || bean.getTranslations().get(currentTranslation) == null) && (translation = bean.getNextTranslation()) != null) {
                currentTranslation = translation.getLanguage();
            }
        }
        list.append("<SELECT name=\"").append(HTMLSelectObjectName).append("\" ").append(onChangeJavascript).append(">\n");
        for (I18NLanguage language : toDisplay) {
            String selected = "";
            if (language.getCode().equals(currentTranslation)) {
                selected = "selected";
            }
            list.append("<option value=\"").append(language.getCode()).append('_').append(language.getTranslationId()).append("\" ").append(selected).append('>').append(language.getLabel()).append("</option>\n");
        }
        list.append("</SELECT>");
        if (bean != null) {
            String path = URLUtil.getApplicationURL();
            String text = ResourceLocator.getGeneralLocalizationBundle((String)userLanguage).getString("GML.translationRemove");
            list.append("&nbsp;<span id=\"delTranslationLink\">");
            if (bean.getTranslations().size() >= 2) {
                list.append("<a href=\"javaScript:document.getElementById('").append(HTMLHiddenRemovedTranslationMode).append("').value='true';removeTranslation();\"><img src=\"").append(path).append("/util/icons/delete.gif\" border=\"0\" valign=\"absmiddle\" title=\"").append(text).append("\" alt=\"").append(text).append("\"></a>");
            }
            list.append("</span>");
            list.append("<input type=\"hidden\" id=\"").append(HTMLHiddenRemovedTranslationMode).append("\" name=\"").append(HTMLHiddenRemovedTranslationMode).append("\" value=\"false\">\n");
        }
        return list.toString();
    }

    public static String updateHTMLLinks(I18NBean<?> bean) {
        StringBuilder javaScript = new StringBuilder();
        Set<String> codes = bean.getTranslations().keySet();
        for (String lang : codes) {
            javaScript.append("document.getElementById(\"translation_").append(lang).append("\").className = \"\";\n");
            javaScript.append("if (lang == '").append(lang).append("')\n");
            javaScript.append("{\n");
            javaScript.append("document.getElementById(\"translation_").append(lang).append("\").className = \"ArrayNavigationOn\";\n");
            javaScript.append("}\n");
        }
        return javaScript.toString();
    }

    public static String[] getLanguageAndTranslationId(HttpServletRequest request) {
        String param = request.getParameter(HTMLSelectObjectName);
        return I18NHelper.getLanguageAndTranslationId(param);
    }

    private static String[] getLanguageAndTranslationId(String param) {
        if (StringUtil.isDefined((String)param)) {
            StringTokenizer tokenizer = new StringTokenizer(param, "_");
            String language = tokenizer.nextToken();
            String translationId = tokenizer.nextToken();
            return new String[]{language, translationId};
        }
        return new String[0];
    }

    public static String getSelectedContentLanguage(HttpServletRequest request) {
        String[] param = I18NHelper.getLanguageAndTranslationId(request);
        if (param.length > 0) {
            return param[0];
        }
        return null;
    }

    public static boolean isI18nContentEnabled() {
        return isI18nContentActivated;
    }

    public static void setI18NInfo(I18NBean<?> bean, HttpServletRequest request) {
        String languageAndTranslationId = request.getParameter(HTMLSelectObjectName);
        String removeTranslation = request.getParameter(HTMLHiddenRemovedTranslationMode);
        I18NHelper.setI18NInfo(bean, languageAndTranslationId, removeTranslation);
    }

    public static void setI18NInfo(I18NBean<?> bean, List<FileItem> parameters) {
        String languageAndTranslationId = I18NHelper.getParameterValue(parameters, HTMLSelectObjectName);
        String removeTranslation = I18NHelper.getParameterValue(parameters, HTMLHiddenRemovedTranslationMode);
        I18NHelper.setI18NInfo(bean, languageAndTranslationId, removeTranslation);
    }

    private static void setI18NInfo(I18NBean<?> bean, String param, String removeParam) {
        String[] languageAndTranslationId = I18NHelper.getLanguageAndTranslationId(param);
        if (languageAndTranslationId.length > 0) {
            String language = languageAndTranslationId[0];
            String translationId = languageAndTranslationId[1];
            bean.setLanguage(language);
            bean.setTranslationId(translationId);
            bean.setRemoveTranslation("true".equalsIgnoreCase(removeParam));
        }
    }

    private static String getParameterValue(List<FileItem> items, String parameterName) {
        for (FileItem item : items) {
            if (!item.isFormField() || !parameterName.equals(item.getFieldName())) continue;
            return item.getString();
        }
        return null;
    }

    static {
        String[] rsLanguages;
        allContentLanguages = new LinkedHashMap<String, List<I18NLanguage>>();
        fallbackContentLanguages = new LinkedHashMap<String, List<I18NLanguage>>();
        nbContentLanguages = 0;
        allContentLanguageCodes = new ArrayList<String>();
        SettingBundle rs = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.i18n");
        for (String contentLanguageCode : rsLanguages = rs.getString("languages").split(",")) {
            if ((contentLanguageCode = contentLanguageCode.trim()).isEmpty()) continue;
            allContentLanguageCodes.add(contentLanguageCode);
            ++nbContentLanguages;
            LocalizationBundle rsLanguage = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.multilang.i18n", (String)contentLanguageCode);
            ArrayList<I18NLanguage> contentLanguageLabels = new ArrayList<I18NLanguage>();
            for (String language : rsLanguages) {
                if ((language = language.trim()).isEmpty()) continue;
                I18NLanguage i18nLanguage = new I18NLanguage(language, rsLanguage.getString("language_" + language));
                contentLanguageLabels.add(i18nLanguage);
            }
            allContentLanguages.put(contentLanguageCode, contentLanguageLabels);
        }
        DEFAULT_LANGUAGE = allContentLanguageCodes.get(0);
        defaultLocale = new Locale(DEFAULT_LANGUAGE);
        isI18nContentActivated = nbContentLanguages > 1;
        ArrayList fallbackLanguageCodes = new ArrayList(DisplayI18NHelper.getLanguages());
        fallbackLanguageCodes.removeAll(allContentLanguageCodes);
        for (String fallbackLanguageCode : fallbackLanguageCodes) {
            LocalizationBundle rsLanguage = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.multilang.i18n", (String)fallbackLanguageCode);
            ArrayList<I18NLanguage> fallbackLanguageLabels = new ArrayList<I18NLanguage>();
            for (String contentLanguageCode : allContentLanguageCodes) {
                I18NLanguage i18nLanguage = new I18NLanguage(contentLanguageCode, rsLanguage.getString("language_" + contentLanguageCode));
                fallbackLanguageLabels.add(i18nLanguage);
            }
            fallbackContentLanguages.put(fallbackLanguageCode, fallbackLanguageLabels);
        }
    }
}

