/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.html.plugin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ecs.xhtml.script;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractPluginInitializationProducer {
    private String language;
    private String jsInstanceVar;
    private Map<String, String> options = new HashMap<String, String>();

    protected static String stringValue(String value) {
        return "'" + WebEncodeHelper.javaStringToJsString((String)value) + "'";
    }

    protected String booleanValue(boolean value) {
        return String.valueOf(value);
    }

    protected String numericValue(Number value) {
        return String.valueOf(value);
    }

    public <T extends AbstractPluginInitializationProducer> T withUserLanguage(String language) {
        this.language = language;
        return (T)this;
    }

    public <T extends AbstractPluginInitializationProducer> T withJsInstanceVar(String jsInstanceVar) {
        this.jsInstanceVar = jsInstanceVar;
        return (T)this;
    }

    protected <T extends AbstractPluginInitializationProducer> T addOption(String name, String value) {
        this.options.put(name, AbstractPluginInitializationProducer.stringValue(value));
        return (T)this;
    }

    protected <T extends AbstractPluginInitializationProducer> T addOption(String name, Stream<Object> values, boolean valuesAreStrings) {
        Stream<Object> decodedValues = values.map(String::valueOf).filter(StringUtil::isDefined).flatMap(v -> Arrays.stream(v.split(",")));
        if (valuesAreStrings) {
            decodedValues = decodedValues.map(AbstractPluginInitializationProducer::stringValue);
        }
        this.options.put(name, decodedValues.collect(Collectors.joining(",", "[", "]")));
        return (T)this;
    }

    public <T extends AbstractPluginInitializationProducer> T addOption(String name, boolean value) {
        this.options.put(name, this.booleanValue(value));
        return (T)this;
    }

    public <T extends AbstractPluginInitializationProducer> T addOption(String name, Number value) {
        this.options.put(name, this.numericValue(value));
        return (T)this;
    }

    public String produce() {
        StringBuilder pluginInit = new StringBuilder();
        pluginInit.append("whenSilverpeasReady(function() {");
        pluginInit.append("var instance = new ").append(this.getClass().getSimpleName().replace("Producer", "")).append("(");
        if (!this.options.isEmpty()) {
            pluginInit.append(this.options.entrySet().stream().map(e -> "\"" + (String)e.getKey() + "\":" + (String)e.getValue()).collect(Collectors.joining(",", "{", "}")));
        }
        pluginInit.append(");");
        if (StringUtil.isDefined((String)this.jsInstanceVar)) {
            pluginInit.append(this.jsInstanceVar).append("=").append("instance;");
        }
        pluginInit.append("});");
        return this.getDependencies() + String.valueOf(new script().setType("text/javascript").addElement(pluginInit.toString()));
    }

    protected String getUserLanguage() {
        return this.language;
    }

    protected abstract String getDependencies();
}

