/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.tracking;

import java.time.Instant;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.ContributionCreation;
import org.silverpeas.core.contribution.ContributionDeletion;
import org.silverpeas.core.contribution.ContributionModification;
import org.silverpeas.core.contribution.ContributionModificationContextHandler;
import org.silverpeas.core.contribution.ContributionMove;
import org.silverpeas.core.contribution.ContributionSettings;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.tracking.ContributionTrackingEvent;
import org.silverpeas.core.contribution.tracking.ModificationTracked;
import org.silverpeas.core.contribution.tracking.TrackedAction;
import org.silverpeas.core.contribution.tracking.TrackedActionType;
import org.silverpeas.core.contribution.tracking.TrackedApplications;

@Service
public class ContributionTrackingService
implements ContributionModification,
ContributionDeletion,
ContributionCreation,
ContributionMove {
    static final String OUTER_MOVE_CONTEXT = "Move from %s to %s";
    static final String INNER_MOVE_CONTEXT = "Move between two nodes within %s";
    @Inject
    private ContributionModificationContextHandler modifHandler;

    @Transactional(value=Transactional.TxType.MANDATORY)
    public void update(Contribution before, Contribution after) {
        this.runIfTrackingEnabled(() -> {
            TrackedActionType type = this.modifHandler.isMinorModification().map(m -> Boolean.TRUE.equals(m) ? TrackedActionType.MINOR_UPDATE : TrackedActionType.MAJOR_UPDATE).orElse(TrackedActionType.UPDATE);
            Instant dateTime = Instant.now();
            User updater = User.getCurrentRequester();
            if (updater == null && (updater = after.getLastUpdater()) == null) {
                updater = User.getSystemUser();
            }
            TrackedAction action = new TrackedAction(type, dateTime, updater);
            this.save(action, before.getIdentifier(), "");
        }, before, after);
    }

    @Transactional(value=Transactional.TxType.MANDATORY)
    public void delete(Contribution contribution) {
        this.runIfTrackingEnabled(() -> {
            TrackedActionType type = TrackedActionType.DELETION;
            Instant dateTime = Instant.now();
            User deleter = User.getCurrentRequester();
            if (deleter == null) {
                deleter = User.getSystemUser();
            }
            TrackedAction action = new TrackedAction(type, dateTime, deleter);
            this.save(action, contribution.getIdentifier(), "");
        }, contribution);
    }

    public void create(Contribution contribution) {
        this.runIfTrackingEnabled(() -> {
            TrackedActionType type = TrackedActionType.CREATION;
            Instant dateTime = Instant.now();
            User creator = User.getCurrentRequester();
            if (creator == null && (creator = contribution.getCreator()) == null) {
                creator = User.getSystemUser();
            }
            TrackedAction action = new TrackedAction(type, dateTime, creator);
            this.save(action, contribution.getIdentifier(), "");
        }, contribution);
    }

    public void move(Contribution before, Contribution after) {
        this.runIfTrackingEnabled(() -> {
            String context;
            TrackedActionType type;
            if (this.isMovingInSameApplication(before, after)) {
                type = TrackedActionType.INNER_MOVE;
                context = String.format(INNER_MOVE_CONTEXT, before.getIdentifier().getComponentInstanceId());
            } else {
                type = TrackedActionType.OUTER_MOVE;
                context = String.format(OUTER_MOVE_CONTEXT, before.getIdentifier().getComponentInstanceId(), after.getIdentifier().getComponentInstanceId());
            }
            Instant dateTime = Instant.now();
            User mover = User.getCurrentRequester();
            if (mover == null) {
                mover = User.getSystemUser();
            }
            TrackedAction action = new TrackedAction(type, dateTime, mover);
            this.save(action, before.getIdentifier(), context);
        }, before, after);
    }

    private void runIfTrackingEnabled(Runnable eventSaving, Contribution ... contributions) {
        if (contributions[0].getClass().isAnnotationPresent(ModificationTracked.class)) {
            TrackedApplications trackedApps = ContributionSettings.getApplicationsTrackedForModifications();
            boolean anAppIsTracked = Stream.of(contributions).map(c -> c.getIdentifier().getComponentInstanceId()).anyMatch(arg_0 -> ((TrackedApplications)trackedApps).isTracked(arg_0));
            if (anAppIsTracked) {
                eventSaving.run();
            }
        }
    }

    public void save(TrackedAction action, ContributionIdentifier contributionId, String context) {
        ContributionTrackingEvent event = new ContributionTrackingEvent(action, contributionId).setContext(context);
        event.save();
    }

    private boolean isMovingInSameApplication(Contribution before, Contribution after) {
        return before.getIdentifier().getComponentInstanceId().equals(after.getIdentifier().getComponentInstanceId());
    }
}

