/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.social;

import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationWithStatus;
import org.silverpeas.core.socialnetwork.model.AbstractSocialInformation;
import org.silverpeas.core.socialnetwork.model.SocialInformationType;
import org.silverpeas.core.util.URLUtil;

public class SocialInformationPublication
extends AbstractSocialInformation {
    private final PublicationDetail publication;

    public SocialInformationPublication(PublicationWithStatus publication) {
        super(publication.getPublication().getPK().toResourceReference());
        this.publication = publication.getPublication();
        if (publication.isUpdate()) {
            this.setAuthor(publication.getPublication().getUpdaterId());
            this.setDate(publication.getPublication().getLastUpdateDate());
        } else {
            this.setAuthor(publication.getPublication().getCreatorId());
            this.setDate(publication.getPublication().getCreationDate());
        }
        String instanceId = publication.getPublication().getInstanceId();
        SocialInformationType type = SocialInformationType.PUBLICATION;
        if (instanceId.startsWith("blog")) {
            type = SocialInformationType.POST;
        } else if (instanceId.startsWith("quickinfo")) {
            type = SocialInformationType.NEWS;
        } else if (instanceId.startsWith("bookmark")) {
            type = SocialInformationType.BOOKMARK;
        } else if (instanceId.startsWith("webSites")) {
            type = SocialInformationType.SITE;
        }
        this.setType(type.toString());
        this.setUrl(URLUtil.getSimpleURL(2, publication.getPublication().getId(), instanceId, false));
        this.setUpdated(publication.isUpdate());
        this.setTitle(publication.getPublication().getTitle());
        this.setDescription(publication.getPublication().getDescription());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SocialInformationPublication other = (SocialInformationPublication)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.author == null ? other.author != null : !this.author.equals(other.author)) {
            return false;
        }
        if (!(this.date == other.date || this.date != null && this.date.equals(other.date))) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        if (this.getTitle() == null ? other.getTitle() != null : !this.getTitle().equals(other.getTitle())) {
            return false;
        }
        return this.getDescription() == null ? other.getDescription() == null : this.getDescription().equals(other.getDescription());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 43 * hash + (this.author != null ? this.author.hashCode() : 0);
        hash = 43 * hash + (this.date != null ? this.date.hashCode() : 0);
        hash = 43 * hash + (this.url != null ? this.url.hashCode() : 0);
        return hash;
    }

    public PublicationDetail getPublication() {
        return this.publication;
    }
}

