/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.dao;

import org.silverpeas.kernel.util.StringUtil;

public class QueryStringFactory {
    private static String selectByFatherPK = null;
    private static String selectByFatherPKPeriodSensitive = null;
    private static String selectByFatherPKAndUserId = null;
    private static String selectByFatherPKPeriodSensitiveAndUserId = null;
    private static String loadRow = null;
    private static String loadRowFields = null;
    private static final String SELECT_BY_NAME;
    private static final String SELECT_BY_NAME_AND_NODE_ID;
    private static String selectNotInFatherPK;

    private QueryStringFactory() {
    }

    public static String getSelectByFatherPK(String tableName) {
        return QueryStringFactory.getSelectByFatherPK(tableName, true, null);
    }

    public static synchronized String getSelectByFatherPK(String tableName, boolean periodSensitive, String userId) {
        if (selectByFatherPKPeriodSensitiveAndUserId == null) {
            selectByFatherPK = QueryStringFactory.buildSelectByFatherPK(tableName, false, false);
            selectByFatherPKPeriodSensitive = QueryStringFactory.buildSelectByFatherPK(tableName, true, false);
            selectByFatherPKAndUserId = QueryStringFactory.buildSelectByFatherPK(tableName, false, true);
            selectByFatherPKPeriodSensitiveAndUserId = QueryStringFactory.buildSelectByFatherPK(tableName, true, true);
        }
        if (StringUtil.isDefined((String)userId)) {
            if (periodSensitive) {
                return selectByFatherPKPeriodSensitiveAndUserId;
            }
            return selectByFatherPKAndUserId;
        }
        if (periodSensitive) {
            return selectByFatherPKPeriodSensitive;
        }
        return selectByFatherPK;
    }

    private static String buildSelectByFatherPK(String tableName, boolean isPeriodSensitive, boolean isUserId) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT P.pubId, P.infoId, P.pubName, P.pubDescription, P.pubCreationDate, ");
        query.append("P.pubBeginDate, P.pubEndDate, P.pubCreatorId, P.pubImportance, P.pubVersion, ");
        query.append("P.pubKeywords, P.pubContent, P.pubStatus, ");
        query.append("P.pubUpdateDate, P.instanceId, P.pubUpdaterId, P.pubValidateDate, ");
        query.append("P.pubValidatorId, P.pubBeginHour, P.pubEndHour, P.pubAuthor, ");
        query.append("P.pubTargetValidatorId, P.pubCloneId, P.pubCloneStatus, P.lang, ");
        query.append("P.pubRemovalDate, P.pubRemoverId, ");
        query.append("F.pubOrder FROM ");
        query.append(tableName).append(" P, ").append(tableName).append("Father F ");
        query.append("WHERE F.instanceId = ? AND F.nodeId = ? AND F.pubId = P.pubId ");
        if (isUserId) {
            query.append("AND (P.pubUpdaterId = ? OR P.pubCreatorId = ? ) ");
        }
        if (isPeriodSensitive) {
            query.append("AND (");
            query.append("( ? > P.pubBeginDate AND ? < P.pubEndDate ) OR ");
            query.append("( ? = P.pubBeginDate AND ? < P.pubEndDate AND ? > P.pubBeginHour ) OR ");
            query.append("( ? > P.pubBeginDate AND ? = P.pubEndDate AND ? < P.pubEndHour ) OR ");
            query.append("( ? = P.pubBeginDate AND ? = P.pubEndDate AND ? > P.pubBeginHour AND ? < P.pubEndHour )");
            query.append(" ) ");
        }
        return query.append(" ORDER BY F.pubOrder ASC").toString();
    }

    public static synchronized String getSelectNotInFatherPK(String tableName) {
        if (selectNotInFatherPK == null) {
            selectNotInFatherPK = "SELECT DISTINCT P.pubId, P.infoId, P.pubName, P.pubDescription, P.pubCreationDate, P.pubBeginDate, P.pubEndDate, P.pubCreatorId, P.pubImportance, P.pubVersion, P.pubKeywords, P.pubContent, P.pubStatus, P.pubUpdateDate, P.instanceId, P.pubUpdaterId, P.pubValidateDate,  P.pubValidatorId, P.pubBeginHour, P.pubEndHour, P.pubAuthor, P.pubTargetValidatorId, P.pubCloneId, P.pubCloneStatus, P.lang, P.pubRemovalDate, P.pubRemoverId FROM " + tableName + " P, " + tableName + "Father F WHERE F.instanceId = ? AND F.nodeId <> ? AND F.pubId = P.pubId AND (( ? > P.pubBeginDate AND ? < P.pubEndDate ) OR ( ? = P.pubBeginDate AND ? < P.pubEndDate AND ? > P.pubBeginHour ) OR ( ? > P.pubBeginDate AND ? = P.pubEndDate AND ? < P.pubEndHour ) OR ( ? = P.pubBeginDate AND ? = P.pubEndDate AND ? > P.pubBeginHour  AND ? < P.pubEndHour )) ";
        }
        return selectNotInFatherPK;
    }

    public static synchronized String getLoadRow(String tableName) {
        if (loadRow == null) {
            loadRow = "select " + QueryStringFactory.getLoadRowFields() + " from " + tableName + " where pubId = ? ";
        }
        return loadRow;
    }

    public static synchronized String getLoadRowFields() {
        if (loadRowFields == null) {
            loadRowFields = "pubid, infoid, pubname, pubdescription, pubcreationdate, pubbegindate, pubenddate, pubcreatorid, pubimportance, pubversion, pubkeywords, pubcontent, pubstatus, pubupdatedate, instanceid, pubupdaterid, pubvalidatedate, pubvalidatorid, pubbeginhour, pubendhour, pubauthor, pubtargetvalidatorid, pubcloneid, pubclonestatus, lang, pubRemovalDate, pubRemoverId";
        }
        return loadRowFields;
    }

    public static String getSelectByName() {
        return SELECT_BY_NAME;
    }

    public static String getSelectByNameAndNodeId() {
        return SELECT_BY_NAME_AND_NODE_ID;
    }

    static {
        selectNotInFatherPK = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM sb_publication_publi pub, sb_publication_publifather pubnode");
        query.append(" WHERE (pub.pubid = pubnode.pubid)");
        query.append(" AND pub.pubname = ?");
        query.append(" AND pub.instanceId = ?");
        query.append(" AND pubnode.nodeid = ?");
        SELECT_BY_NAME_AND_NODE_ID = query.toString();
        query = new StringBuilder();
        query.append("SELECT * FROM sb_publication_publi WHERE pubName = ? AND instanceId = ? ");
        SELECT_BY_NAME = query.toString();
    }
}

