/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.wysiwyg.service.directive;

import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.silverpeas.core.contribution.content.wysiwyg.service.directive.AbstractDirective;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.util.StringUtil;

public class SilverpeasLinkCssApplierDirective
extends AbstractDirective {
    @Override
    public void prepareReplacements(Source source, Map<String, String> replacements) {
        List linkElements = source.getAllElements("a");
        for (Element currentLink : linkElements) {
            StartTag linkStartTag = currentLink.getStartTag();
            if (!this.isCompliantTarget(linkStartTag)) continue;
            String href = StringUtil.defaultStringIfNotDefined((String)currentLink.getAttributeValue("href"));
            if (URLUtil.isPermalink(href)) {
                this.apply(linkStartTag, "sp-permalink", replacements);
                continue;
            }
            if (!href.contains(URLUtil.getApplicationURL())) continue;
            this.apply(linkStartTag, "sp-link", replacements);
        }
    }

    private void apply(StartTag linkStartTag, String cssClass, Map<String, String> replacements) {
        this.modifyElementAttribute(linkStartTag, "class", c -> {
            if (c == null) {
                return cssClass;
            }
            String cleanedCssClasses = c.replaceAll("[ ]*(sp-permalink|sp-link)", "").trim();
            Object cssClassToAdd = cleanedCssClasses.isEmpty() ? cssClass : " " + cssClass;
            return cleanedCssClasses + (String)cssClassToAdd;
        }, replacements);
    }

    private boolean isCompliantTarget(StartTag linkStartTag) {
        return StringUtil.isNotDefined((String)linkStartTag.getAttributeValue("target"));
    }
}

