/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.wysiwyg.service;

import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygContentTransformerDirective;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygContentTransformerProcess;
import org.silverpeas.core.contribution.content.wysiwyg.service.directive.ImageUrlAccordingToHtmlSizeDirective;
import org.silverpeas.core.contribution.content.wysiwyg.service.directive.MailLinkCssApplierDirective;
import org.silverpeas.core.contribution.content.wysiwyg.service.directive.OpenLinkOnBlankPageDirective;
import org.silverpeas.core.contribution.content.wysiwyg.service.directive.SanitizeDirective;
import org.silverpeas.core.contribution.content.wysiwyg.service.directive.SilverpeasLinkCssApplierDirective;
import org.silverpeas.core.contribution.content.wysiwyg.service.directive.VariablesReplacementDirective;
import org.silverpeas.core.contribution.content.wysiwyg.service.process.MailContentProcess;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

public class WysiwygContentTransformer {
    private final String wysiwygContent;
    private final List<WysiwygContentTransformerDirective> directives = new ArrayList<WysiwygContentTransformerDirective>();

    public static WysiwygContentTransformer on(String wysiwygContent) {
        return new WysiwygContentTransformer(wysiwygContent);
    }

    private WysiwygContentTransformer(String wysiwygContent) {
        this.wysiwygContent = wysiwygContent;
    }

    public WysiwygContentTransformer modifyImageUrlAccordingToHtmlSizeDirective() {
        this.directives.add(new ImageUrlAccordingToHtmlSizeDirective());
        return this;
    }

    private WysiwygContentTransformer modifyImageUrlAccordingToHtmlSizeDirectiveWithImageMinWidthIfAny() {
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.mail.mail");
        this.directives.add(new ImageUrlAccordingToHtmlSizeDirective(settings.getInteger("image.resize.min-width", 0)));
        return this;
    }

    public WysiwygContentTransformer resolveVariablesDirective() {
        this.directives.add(new VariablesReplacementDirective());
        return this;
    }

    public WysiwygContentTransformer applySilverpeasLinkCssDirective() {
        this.directives.add(new SilverpeasLinkCssApplierDirective());
        return this;
    }

    public WysiwygContentTransformer applyOpenLinkOnBlankDirective() {
        this.directives.add(new OpenLinkOnBlankPageDirective());
        return this;
    }

    public WysiwygContentTransformer applySanitizeDirective() {
        this.directives.add(new SanitizeDirective());
        return this;
    }

    public WysiwygContentTransformer applyMailLinkCssDirective() {
        this.directives.add(new MailLinkCssApplierDirective());
        return this;
    }

    public String transform() {
        String transformedWysiwyg = this.wysiwygContent;
        for (WysiwygContentTransformerDirective directive : this.directives) {
            transformedWysiwyg = directive.execute(transformedWysiwyg);
        }
        return transformedWysiwyg;
    }

    public <R> R transform(WysiwygContentTransformerProcess<R> process) throws SilverpeasException {
        return process.execute(this.transform());
    }

    public MailContentProcess.MailResult toMailContent() throws SilverpeasException {
        return this.modifyImageUrlAccordingToHtmlSizeDirectiveWithImageMinWidthIfAny().resolveVariablesDirective().transform(new MailContentProcess());
    }
}

