/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.field;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.field.TextField;

public class JdbcField
extends TextField {
    private static final long serialVersionUID = 1L;
    public static final String TYPE = "jdbc";
    private static final String VARIABLE_USER_ID = "$$userId";
    private String value = "";

    @Override
    public String getTypeName() {
        return TYPE;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public void setStringValue(String value) {
        this.value = value;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public Connection connect(String dataSourceName, String login, String password) throws FormException {
        Connection connection;
        try {
            DataSource dataSource = (DataSource)InitialContext.doLookup(dataSourceName);
            connection = dataSource.getConnection(login, password);
        }
        catch (Exception ex) {
            throw new FormException(ex);
        }
        return connection;
    }

    public Collection<String> selectSql(Connection connection, String query, String currentUserId) throws FormException {
        ArrayList<String> result = new ArrayList<String>();
        query = query.replace(VARIABLE_USER_ID, currentUserId);
        if (connection != null) {
            Object sqlQuery = query.toLowerCase().startsWith("select") ? query : "select " + query;
            try (PreparedStatement prepStmt = connection.prepareStatement((String)sqlQuery);
                 ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new FormException(e);
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

