/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ecs.html.Input;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.displayers.CheckBoxDisplayer;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.core.util.WebEncodeHelper;

public class UniqueIdFieldDisplayer
extends AbstractFieldDisplayer<TextField> {
    public String[] getManagedTypes() {
        return new String[]{"text"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String value;
        if (field == null) {
            return;
        }
        String fieldName = template.getFieldName();
        Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
        Object defaultValue = Long.toString(new Date().getTime());
        String suffix = parameters.get("suffix");
        if ("userid".equalsIgnoreCase(suffix)) {
            defaultValue = (String)defaultValue + "-" + pageContext.getUserId();
        }
        String string = value = !field.isNull() ? field.getValue(pageContext.getLanguage()) : defaultValue;
        if (pageContext.isBlankFieldsUse()) {
            value = "";
        }
        Input input2 = new Input();
        input2.setName(fieldName);
        input2.setID(fieldName);
        input2.setValue(WebEncodeHelper.javaStringToHtmlString((String)value));
        input2.setType(template.isHidden() ? "hidden" : "text");
        input2.setSize(parameters.getOrDefault("size", "50"));
        input2.setReadOnly(true);
        out.println(input2);
    }

    @Override
    public List<String> update(String newValue, TextField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        CheckBoxDisplayer.setFieldValue(newValue, field, pagesContext);
        return Collections.emptyList();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

