/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import com.novell.ldap.LDAPConnection;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.displayers.JdbcFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.LdapField;

public class LdapFieldDisplayer
extends AbstractFieldDisplayer<LdapField> {
    private static final String[] MANAGED_TYPES = new String[]{"ldap"};
    private static final String MANDATORY_IMG = Util.getIcon("mandatoryField");
    private static final String THIS_O_AUTO_COMP = " this.oAutoComp";

    public String[] getManagedTypes() {
        return MANAGED_TYPES;
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) {
        LdapFieldDisplayer.produceMandatoryCheck(out, template, pagesContext);
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, LdapField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        String value = "";
        String currentUserId = pagesContext.getUserId();
        String language = pagesContext.getLanguage();
        String fieldName = template.getFieldName();
        Map<String, String> parameters = template.getParameters(language);
        LdapField ldapField = !field.getTypeName().equals("ldap") ? new LdapField() : field;
        if (!field.isNull()) {
            value = field.getValue(language);
        }
        Params params = LdapFieldDisplayer.getParams(parameters);
        Collection<String> listRes = LdapFieldDisplayer.requestLDAPService(ldapField, params, currentUserId);
        StringBuilder html2 = new StringBuilder(10000);
        if (listRes != null && !listRes.isEmpty()) {
            LdapFieldDisplayer.generateHTMLFields(template, pagesContext, html2, fieldName, value, listRes, params);
        } else {
            LdapFieldDisplayer.generateEmptyHTMLFields(template, params, html2, fieldName);
        }
        out.println(html2);
    }

    private static void generateEmptyHTMLFields(FieldTemplate template, Params params, StringBuilder html2, String fieldName) {
        if ("1".equals(params.valueFieldType)) {
            html2.append("<select name=\"").append(fieldName).append("\"");
            if (template.isDisabled() || template.isReadOnly()) {
                html2.append(" disabled=\"disabled\"");
            }
            html2.append(" >\n");
            html2.append("</select>\n");
            if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden()) {
                html2.append("&nbsp;<img src=\"").append(MANDATORY_IMG).append("\" width=\"5\" height=\"5\" border=\"0\" alt=\"\"/>&nbsp;\n");
            }
        } else {
            html2.append("<input type=\"text\" name=\"").append(fieldName).append("\"");
            if (template.isDisabled() || template.isReadOnly()) {
                html2.append(" disabled=\"disabled\"");
            }
            html2.append(" />\n");
            if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden()) {
                html2.append("&nbsp;<img src=\"").append(MANDATORY_IMG);
                html2.append("\" width=\"5\" height=\"5\" border=\"0\" alt=\"\"/>&nbsp;\n");
            }
        }
    }

    private static void generateHTMLFields(FieldTemplate template, PagesContext pagesContext, StringBuilder html2, String fieldName, String value, Collection<String> listRes, Params params) {
        int zindex = 100;
        html2.append("<style type=\"text/css\">\n").append(" #listAutocomplete").append(fieldName);
        html2.append(" {\n ").append("  width:15em;\n").append("  padding-bottom:2em;\n");
        html2.append(" }\n").append(" #container").append(fieldName).append(" {\n");
        html2.append("  z-index:").append(zindex);
        html2.append("; /* z-index needed on top instance for ie & sf absolute inside relative issue ");
        html2.append("*/\n").append(" }\n").append(" #").append(fieldName).append(" {\n");
        html2.append("  _position:absolute; /* abs pos needed for ie quirks */\n").append(" }\n");
        html2.append("</style>\n").append("<div id=\"listAutocomplete").append(fieldName).append("\">\n");
        html2.append("<input id=\"").append(fieldName).append("\" name=\"").append(fieldName);
        html2.append("\" type=\"text\"");
        if (value != null) {
            html2.append(" value=\"").append(value).append("\"");
        }
        if (template.isDisabled() || template.isReadOnly()) {
            html2.append(" disabled");
        }
        html2.append("/>\n").append("<div id=\"container").append(fieldName).append("\"/>\n");
        html2.append("</div>\n");
        if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pagesContext.useMandatory()) {
            html2.append("<img src=\"").append(MANDATORY_IMG).append("\" width=\"5\" height=\"5\" ");
            html2.append("border=\"0\" alt=\"\" style=\"position:absolute;left:16em;top:5px\"/>\n");
        }
        JdbcFieldDisplayer.generateFragmentHTML(listRes, html2, fieldName);
        html2.append(" this.oACDS").append(fieldName);
        html2.append(" = new YAHOO.util.LocalDataSource(listArray").append(fieldName).append(");\n");
        html2.append(THIS_O_AUTO_COMP).append(fieldName).append(" = new YAHOO.widget.AutoComplete('");
        html2.append(fieldName).append("','container").append(fieldName).append("', this.oACDS");
        html2.append(fieldName).append(");\n").append(THIS_O_AUTO_COMP).append(fieldName);
        html2.append(".prehighlightClassName = \"yui-ac-prehighlight\";\n");
        LdapFieldDisplayer.generateAutoComp(fieldName, params.valueFieldType, html2, THIS_O_AUTO_COMP);
        LdapFieldDisplayer.generateYahooCode(fieldName, html2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> requestLDAPService(LdapField ldapField, Params params, String currentUserId) throws FormException {
        Collection<String> listRes;
        LDAPConnection ldapConnection = null;
        try {
            ldapConnection = ldapField.connectLdap(params.host, params.port);
            byte[] tabPassword = null;
            if (params.password != null) {
                tabPassword = params.password.getBytes();
            }
            ldapField.bindLdap(ldapConnection, params.version, params.baseDN, tabPassword);
            if (params.maxResultDisplayed != null) {
                ldapField.setConstraintLdap(ldapConnection, params.maxResultDisplayed);
            }
            boolean boolSearchTypeOnly = "true".equals(params.searchTypeOnly);
            listRes = ldapField.searchLdap(ldapConnection, params.searchBase, params.searchScope, params.searchFilter, params.searchAttribute, boolSearchTypeOnly, currentUserId);
            ldapField.disconnectLdap(ldapConnection);
        }
        catch (Throwable throwable) {
            ldapField.disconnectLdap(ldapConnection);
            throw throwable;
        }
        return listRes;
    }

    private static Params getParams(Map<String, String> parameters) {
        String host = null;
        String port = null;
        String version = null;
        String baseDN = null;
        String password = null;
        String searchBase = null;
        String searchScope = null;
        String searchFilter = null;
        String searchAttribute = null;
        String searchTypeOnly = null;
        String maxResultDisplayed = null;
        String valueFieldType = "1";
        if (parameters.containsKey("host")) {
            host = parameters.get("host");
        }
        if (parameters.containsKey("port")) {
            port = parameters.get("port");
        }
        if (parameters.containsKey("version")) {
            version = parameters.get("version");
        }
        if (parameters.containsKey("baseDN")) {
            baseDN = parameters.get("baseDN");
        }
        if (parameters.containsKey("password")) {
            password = parameters.get("password");
        }
        if (parameters.containsKey("searchBase")) {
            searchBase = parameters.get("searchBase");
        }
        if (parameters.containsKey("searchScope")) {
            searchScope = parameters.get("searchScope");
        }
        if (parameters.containsKey("searchFilter")) {
            searchFilter = parameters.get("searchFilter");
        }
        if (parameters.containsKey("searchAttribute")) {
            searchAttribute = parameters.get("searchAttribute");
        }
        if (parameters.containsKey("searchTypeOnly")) {
            searchTypeOnly = parameters.get("searchTypeOnly");
        }
        if (parameters.containsKey("maxResultDisplayed")) {
            maxResultDisplayed = parameters.get("maxResultDisplayed");
        }
        if (parameters.containsKey("valueFieldType")) {
            valueFieldType = parameters.get("valueFieldType");
        }
        Params params = new Params();
        params.host = host;
        params.port = port;
        params.version = version;
        params.baseDN = baseDN;
        params.password = password;
        params.searchBase = searchBase;
        params.searchScope = searchScope;
        params.searchFilter = searchFilter;
        params.searchAttribute = searchAttribute;
        params.searchTypeOnly = searchTypeOnly;
        params.maxResultDisplayed = maxResultDisplayed;
        params.valueFieldType = valueFieldType;
        return params;
    }

    static void generateAutoComp(String fieldName, String valueFieldType, StringBuilder html2, String thisOAutoComp) {
        html2.append(thisOAutoComp).append(fieldName).append(".typeAhead = true;\n");
        html2.append(thisOAutoComp).append(fieldName).append(".useShadow = true;\n");
        html2.append(thisOAutoComp).append(fieldName).append(".minQueryLength = 0;\n");
        if ("1".equals(valueFieldType)) {
            html2.append(thisOAutoComp).append(fieldName).append(".forceSelection = true;\n");
        }
        html2.append(thisOAutoComp).append(fieldName).append(".textboxFocusEvent.subscribe(function(){\n");
    }

    static void generateYahooCode(String fieldName, StringBuilder html2) {
        html2.append("  var sInputValue = YAHOO.util.Dom.get('").append(fieldName).append("').value;\n");
        html2.append("  if(sInputValue.length == 0) {\n");
        html2.append("   var oSelf = this;\n");
        html2.append("   setTimeout(function(){oSelf.sendQuery(sInputValue);},0);\n");
        html2.append("  }\n");
        html2.append(" });\n");
        html2.append("</script>\n");
    }

    @Override
    public List<String> update(String newValue, LdapField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (!"ldap".equals(field.getTypeName())) {
            throw new FormException("Incorrect field type '{0}', expected; {0}", "ldap");
        }
        if (!field.acceptValue(newValue, pagesContext.getLanguage())) {
            throw new FormException("Incorrect field value type. Expected {0}", "ldap");
        }
        field.setValue(newValue, pagesContext.getLanguage());
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }

    private static class Params {
        String host;
        String port;
        String version;
        String baseDN;
        String password;
        String searchBase;
        String searchScope;
        String searchFilter;
        String searchAttribute;
        String searchTypeOnly;
        String maxResultDisplayed;
        String valueFieldType;

        private Params() {
        }
    }
}

