/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.process.huge;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentException;
import org.silverpeas.core.util.ServiceProvider;

@Service
@Singleton
public class AttachmentHugeProcessManager {
    private final Set<String> allInstanceIds = Collections.synchronizedSet(new HashSet());
    private final ThreadLocal<Set<String>> instanceIdsOfThread = new ThreadLocal();

    public static AttachmentHugeProcessManager get() {
        return (AttachmentHugeProcessManager)ServiceProvider.getService(AttachmentHugeProcessManager.class, (Annotation[])new Annotation[0]);
    }

    public boolean isOneRunningOnInstance(String instanceId) {
        return this.allInstanceIds.contains(instanceId);
    }

    public void checkNoOneIsRunningOnInstance(String instanceId) {
        if (this.isOneRunningOnInstance(instanceId)) {
            throw new AttachmentException(MessageFormat.format("Huge process over attachments of instance {0} is currently running.", instanceId));
        }
    }

    void startForInstances(Set<String> instanceIds) {
        instanceIds.forEach(this::checkNoOneIsRunningOnInstance);
        Set newInstanceIdsOfThread = Optional.ofNullable(this.instanceIdsOfThread.get()).orElseGet(HashSet::new);
        this.allInstanceIds.addAll(instanceIds);
        newInstanceIdsOfThread.addAll(instanceIds);
        this.instanceIdsOfThread.set(newInstanceIdsOfThread);
    }

    void endForInstances(Set<String> instanceIds) {
        this.allInstanceIds.removeAll(instanceIds);
        Optional.ofNullable(this.instanceIdsOfThread.get()).ifPresent(s -> {
            s.removeAll(instanceIds);
            if (s.isEmpty()) {
                this.instanceIdsOfThread.remove();
            }
        });
    }
}

