/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.clipboard;

import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import org.silverpeas.core.clipboard.SKDException;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.annotation.Nullable;

public class SilverpeasKeyData
implements Serializable {
    private static final long serialVersionUID = 6975015837634530711L;
    private static final String ID_KEY = "ID";
    private static final String INSTANCE_ID_KEY = "COMPONENT";
    private static final String TITLE_KEY = "TITLE";
    private static final String AUTHOR_KEY = "AUTHOR";
    private static final String DESC_KEY = "DESC";
    private static final String TEXT_KEY = "TEXT";
    private static final String TYPE_KEY = "TYPE";
    private static final String LINK_KEY = "LINK";
    private Date creationDate = null;
    private final Properties keyData = new Properties();

    public SilverpeasKeyData(String id) {
        this.keyData.setProperty(ID_KEY, id);
    }

    public SilverpeasKeyData(String id, String componentInstanceId) {
        this.keyData.setProperty(ID_KEY, id);
        this.keyData.setProperty(INSTANCE_ID_KEY, componentInstanceId);
    }

    public void setTitle(String title) {
        this.keyData.setProperty(TITLE_KEY, title);
    }

    public void setAuthor(String author) {
        this.keyData.setProperty(AUTHOR_KEY, author);
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public void setDesc(String desc) {
        this.keyData.setProperty(DESC_KEY, desc);
    }

    public void setText(String text) {
        this.keyData.setProperty(TEXT_KEY, text);
    }

    public void setType(String type) {
        this.keyData.setProperty(TYPE_KEY, type);
    }

    public void setLink(String link) {
        this.keyData.setProperty(LINK_KEY, link);
    }

    public void setProperty(String key, String value) throws SKDException {
        if (this.keyData.containsKey(key)) {
            throw new SKDException("The property already contains the key " + key, new String[0]);
        }
        this.keyData.setProperty(key, value);
    }

    @NonNull
    public String getId() {
        return this.keyData.getProperty(ID_KEY);
    }

    @Nullable
    public String getComponentInstanceId() {
        return this.keyData.getProperty(INSTANCE_ID_KEY);
    }

    @NonNull
    public String getTitle() {
        return this.keyData.getProperty(TITLE_KEY);
    }

    public String getAuthor() {
        return this.keyData.getProperty(AUTHOR_KEY);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getDesc() {
        return this.keyData.getProperty(DESC_KEY);
    }

    public String getText() {
        return this.keyData.getProperty(TEXT_KEY);
    }

    @NonNull
    public String getType() {
        return this.keyData.getProperty(TYPE_KEY);
    }

    @NonNull
    public String getLink() {
        return this.keyData.getProperty(LINK_KEY);
    }

    @Nullable
    public String getProperty(String key) {
        return this.keyData.getProperty(key);
    }
}

