/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.ical4j;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TextList;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.parameter.Rsvp;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Name;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.RecurrenceId;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.calendar.Attendee;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.CalendarEventUtil;
import org.silverpeas.core.calendar.InternalAttendee;
import org.silverpeas.core.calendar.VisibilityLevel;
import org.silverpeas.core.calendar.ical4j.HtmlProperty;
import org.silverpeas.core.calendar.ical4j.ICal4JDateCodec;
import org.silverpeas.core.calendar.ical4j.ICal4JRecurrenceCodec;
import org.silverpeas.core.calendar.icalendar.ICalendarExporter;
import org.silverpeas.core.importexport.ExportDescriptor;
import org.silverpeas.core.importexport.ExportException;
import org.silverpeas.core.util.html.HtmlCleaner;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class ICal4JExporter
implements ICalendarExporter {
    private static final String MAIL_TO = "mailto:";
    private static final String HIDDEN_DATA = "";
    @Inject
    private ICal4JDateCodec iCal4JDateCodec;
    @Inject
    private ICal4JRecurrenceCodec iCal4JRecurrenceCodec;

    @PostConstruct
    private void init() {
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.validation.relaxed", (boolean)true);
    }

    public void exports(ExportDescriptor descriptor, Supplier<Stream<CalendarEvent>> supplier) throws ExportException {
        try {
            Calendar calendar = (Calendar)descriptor.getParameter("calendar");
            net.fortuna.ical4j.model.Calendar iCalCalendar = new net.fortuna.ical4j.model.Calendar();
            iCalCalendar.getProperties().add((Property)new ProdId("-//Silverpeas//iCal4j 2.0//FR"));
            iCalCalendar.getProperties().add((Property)Version.VERSION_2_0);
            iCalCalendar.getProperties().add((Property)CalScale.GREGORIAN);
            iCalCalendar.getProperties().add((Property)Method.PUBLISH);
            iCalCalendar.getProperties().add((Property)new Name(calendar.getTitle()));
            TimeZone tz = this.iCal4JDateCodec.getTimeZone(calendar.getZoneId());
            iCalCalendar.getComponents().add((Object)tz.getVTimeZone());
            iCalCalendar.getProperties().add((Property)new XProperty("X-WR-CALNAME", calendar.getTitle()));
            iCalCalendar.getProperties().add((Property)new XProperty("X-WR-TIMEZONE", tz.getID()));
            try (Stream<CalendarEvent> events = supplier.get();){
                events.forEach(event -> {
                    VEvent iCalEvent = this.convertToICalEvent(descriptor, calendar, (CalendarEvent)event, event.asCalendarComponent());
                    if (event.isRecurrent()) {
                        this.setICalRecurrence((CalendarEvent)event, iCalEvent);
                        event.getPersistedOccurrences().stream().sorted(CalendarEventOccurrence.COMPARATOR_BY_DATE_DESC).forEach(occurrence -> {
                            VEvent occICalEvent = this.convertToICalEvent(descriptor, calendar, (CalendarEventOccurrence)occurrence);
                            iCalCalendar.getComponents().add((Object)occICalEvent);
                        });
                    }
                    iCalCalendar.getComponents().add((Object)iCalEvent);
                });
            }
            CalendarOutputter writer = new CalendarOutputter();
            writer.output(iCalCalendar, descriptor.getOutputStream());
        }
        catch (Exception e) {
            throw new ExportException("The export of the events in iCal formatted text has failed!", (Throwable)e);
        }
    }

    private VEvent convertToICalEvent(ExportDescriptor descriptor, Calendar calendar, CalendarEventOccurrence occurrence) {
        CalendarComponent occComponent = occurrence.asCalendarComponent();
        CalendarComponent evtComponent = occurrence.getCalendarEvent().asCalendarComponent();
        VEvent occICalEvent = this.convertToICalEvent(descriptor, calendar, occurrence.getCalendarEvent(), occComponent);
        Date occOrigStartDate = this.iCal4JDateCodec.encode(true, evtComponent, occurrence.getOriginalStartDate());
        occICalEvent.getProperties().add((Property)new RecurrenceId(occOrigStartDate));
        return occICalEvent;
    }

    private VEvent convertToICalEvent(ExportDescriptor descriptor, Calendar calendar, CalendarEvent event, CalendarComponent component) {
        boolean mustHideData = this.mustHideData(descriptor, event);
        VEvent iCalEvent = this.initICalEvent(calendar, event, component, mustHideData);
        this.setICalUuid(event, iCalEvent);
        this.setICalDescription(component, iCalEvent, mustHideData);
        this.setICalVisibility(event, iCalEvent);
        this.setICalPriority(component, iCalEvent);
        this.setICalLocation(component, iCalEvent, mustHideData);
        this.setICalUrl(component, iCalEvent, mustHideData);
        this.setICalCategories(event, iCalEvent, mustHideData);
        this.setICalAttendees(component, iCalEvent, mustHideData);
        return iCalEvent;
    }

    private void setICalRecurrence(CalendarEvent event, VEvent iCalEvent) {
        Recur recur = this.iCal4JRecurrenceCodec.encode(event);
        iCalEvent.getProperties().add((Property)new RRule(recur));
        if (!event.getRecurrence().getExceptionDates().isEmpty()) {
            iCalEvent.getProperties().add((Property)new ExDate(this.iCal4JRecurrenceCodec.convertExceptionDates(event)));
        }
    }

    private void setICalPriority(CalendarComponent component, VEvent iCalEvent) {
        iCalEvent.getProperties().add((Property)new Priority(component.getPriority().getICalLevel()));
    }

    private void setICalVisibility(CalendarEvent event, VEvent iCalEvent) {
        iCalEvent.getProperties().add((Property)new Clazz(event.getVisibilityLevel().name()));
    }

    private void setICalLocation(CalendarComponent component, VEvent iCalEvent, boolean hideData) {
        if (!hideData && StringUtil.isDefined((String)component.getLocation())) {
            iCalEvent.getProperties().add((Property)new Location(component.getLocation()));
        }
    }

    private void setICalAttendees(CalendarComponent component, VEvent iCalEvent, boolean hideData) {
        if (!hideData && component.getAttendees().isEmpty()) {
            iCalEvent.getProperties().add((Property)Status.VEVENT_CONFIRMED);
        } else if (!hideData) {
            iCalEvent.getProperties().add((Property)this.convertOrganizer(component.getCreator()));
            Mutable mutableStatus = Mutable.of((Object)Status.VEVENT_CONFIRMED);
            component.getAttendees().stream().sorted(Comparator.comparing(Attendee::getId)).forEach(attendee -> {
                iCalEvent.getProperties().add((Property)this.convertAttendee((Attendee)attendee));
                if (Attendee.ParticipationStatus.ACCEPTED != attendee.getParticipationStatus()) {
                    mutableStatus.set((Object)Status.VEVENT_TENTATIVE);
                }
            });
            iCalEvent.getProperties().add((Property)mutableStatus.get());
        }
    }

    private void setICalCategories(CalendarEvent event, VEvent iCalEvent, boolean hideData) {
        TextList categoryList;
        if (!hideData && !(categoryList = new TextList(event.getCategories().asArray())).isEmpty()) {
            iCalEvent.getProperties().add((Property)new Categories(categoryList));
        }
    }

    private void setICalUrl(CalendarComponent component, VEvent iCalEvent, boolean hideData) {
        Optional url;
        Optional optional = url = hideData ? Optional.empty() : component.getAttributes().get("url");
        if (url.isPresent()) {
            try {
                iCalEvent.getProperties().add((Property)new Url(new URI((String)url.get())));
            }
            catch (URISyntaxException ex) {
                throw new SilverpeasRuntimeException(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private VEvent initICalEvent(Calendar calendar, CalendarEvent event, CalendarComponent component, boolean hideData) {
        Date startDate = this.iCal4JDateCodec.encode(event.isRecurrent(), component, component.getPeriod().getStartDate());
        Date endDate = this.iCal4JDateCodec.encode(event.isRecurrent(), component, component.getPeriod().getEndDate());
        DateTime createdDate = this.iCal4JDateCodec.encode(component.getCreationDate().toInstant().atOffset(ZoneOffset.UTC));
        DateTime lastUpdateDate = this.iCal4JDateCodec.encode(component.getLastUpdateDate().toInstant().atOffset(ZoneOffset.UTC));
        String title = hideData ? HIDDEN_DATA : CalendarEventUtil.formatTitle(component, calendar.getComponentInstanceId(), true);
        VEvent iCalEvent = component.getPeriod().isInDays() && startDate.equals((Object)endDate) ? new VEvent(startDate, title) : new VEvent(startDate, endDate, title);
        iCalEvent.getProperties().add((Property)new Created(createdDate));
        iCalEvent.getProperties().add((Property)new LastModified(lastUpdateDate));
        iCalEvent.getProperties().add((Property)new Sequence((int)component.getSequence()));
        return iCalEvent;
    }

    private void setICalDescription(CalendarComponent component, VEvent iCalEvent, boolean hideData) {
        String description;
        String string = description = hideData ? HIDDEN_DATA : component.getDescription();
        if (StringUtil.isDefined((String)description)) {
            HtmlCleaner cleaner = new HtmlCleaner();
            String plainText = HIDDEN_DATA;
            try {
                plainText = cleaner.cleanHtmlFragment(description);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
            }
            iCalEvent.getProperties().add((Property)new Description(plainText));
            iCalEvent.getProperties().add((Property)new HtmlProperty(description));
        }
    }

    private void setICalUuid(CalendarEvent event, VEvent iCalEvent) {
        String eventId = event.getExternalId() != null ? event.getExternalId() : event.getId();
        iCalEvent.getProperties().add((Property)new Uid(eventId));
    }

    private Organizer convertOrganizer(User user) {
        try {
            Organizer iCalEventOrganizer = StringUtil.isDefined((String)user.getEmailAddress()) ? new Organizer(MAIL_TO + user.getEmailAddress()) : new Organizer();
            iCalEventOrganizer.getParameters().add((Parameter)new Cn(user.getDisplayedName()));
            return iCalEventOrganizer;
        }
        catch (URISyntaxException ex) {
            throw new SilverpeasRuntimeException("Malformed organizer URI: " + String.valueOf(user), (Throwable)ex);
        }
    }

    private net.fortuna.ical4j.model.property.Attendee convertAttendee(Attendee attendee) {
        return this.convertAttendee(attendee, attendee.getParticipationStatus());
    }

    private net.fortuna.ical4j.model.property.Attendee convertAttendee(Attendee attendee, Attendee.ParticipationStatus participationStatus) {
        try {
            net.fortuna.ical4j.model.property.Attendee iCalEventAttendee;
            if (attendee instanceof InternalAttendee) {
                InternalAttendee internalAttendee = (InternalAttendee)attendee;
                String displayedName = internalAttendee.getUser().getDisplayedName();
                iCalEventAttendee = StringUtil.isDefined((String)internalAttendee.getUser().getEmailAddress()) ? new net.fortuna.ical4j.model.property.Attendee(MAIL_TO + internalAttendee.getUser().getEmailAddress()) : new net.fortuna.ical4j.model.property.Attendee(MAIL_TO + displayedName);
                iCalEventAttendee.getParameters().add((Parameter)new Cn(displayedName));
            } else {
                iCalEventAttendee = new net.fortuna.ical4j.model.property.Attendee(MAIL_TO + attendee.getId());
                iCalEventAttendee.getParameters().add((Parameter)new Cn(attendee.getId()));
            }
            iCalEventAttendee.getParameters().add((Parameter)CuType.INDIVIDUAL);
            iCalEventAttendee.getParameters().add((Parameter)Rsvp.TRUE);
            this.convertPresenceStatus(attendee.getPresenceStatus()).ifPresent(role -> iCalEventAttendee.getParameters().add((Parameter)role));
            this.convertParticipationStatus(participationStatus).ifPresent(partStat -> iCalEventAttendee.getParameters().add((Parameter)partStat));
            return iCalEventAttendee;
        }
        catch (URISyntaxException ex) {
            throw new SilverpeasRuntimeException("Malformed attendee URI: " + String.valueOf(attendee), (Throwable)ex);
        }
    }

    private Optional<Role> convertPresenceStatus(Attendee.PresenceStatus status) {
        switch (status) {
            case REQUIRED: {
                return Optional.of(Role.REQ_PARTICIPANT);
            }
            case OPTIONAL: {
                return Optional.of(Role.OPT_PARTICIPANT);
            }
        }
        return Optional.empty();
    }

    private Optional<PartStat> convertParticipationStatus(Attendee.ParticipationStatus status) {
        switch (status) {
            case ACCEPTED: {
                return Optional.of(PartStat.ACCEPTED);
            }
            case DECLINED: {
                return Optional.of(PartStat.DECLINED);
            }
            case TENTATIVE: {
                return Optional.of(PartStat.TENTATIVE);
            }
            case DELEGATED: {
                return Optional.of(PartStat.DELEGATED);
            }
        }
        return Optional.of(PartStat.NEEDS_ACTION);
    }

    private boolean mustHideData(ExportDescriptor descriptor, CalendarEvent event) {
        Object value = descriptor.getParameter("hidePrivateData");
        boolean required = value instanceof Boolean && (Boolean)value != false || value instanceof String && StringUtil.getBooleanValue((String)((String)value));
        return required && VisibilityLevel.PRIVATE == event.getVisibilityLevel();
    }
}

