/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
@Singleton
public class GroupCache {
    private final ConcurrentMap<String, List<String>> map = new ConcurrentHashMap<String, List<String>>();

    public synchronized void clearCache() {
        this.map.clear();
    }

    public Optional<List<String>> getAllGroupIdsOfUser(String userId) {
        return Optional.ofNullable((List)this.map.get(userId));
    }

    public List<String> setAllGroupIdsOfUser(String userId, List<String> groupIds) {
        Objects.requireNonNull(groupIds);
        return this.map.putIfAbsent(userId, groupIds);
    }

    public void removeCacheOfUser(String userId) {
        this.map.remove(userId);
    }
}

