/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space.quota;

import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.admin.quota.model.Quota;
import org.silverpeas.core.admin.quota.offset.AbstractQuotaCountingOffset;
import org.silverpeas.core.admin.quota.service.AbstractQuotaService;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.quota.AbstractSpaceQuotaKey;
import org.silverpeas.core.admin.space.quota.SpaceQuotaService;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class AbstractSpaceQuotaService<T extends AbstractSpaceQuotaKey>
extends AbstractQuotaService<T>
implements SpaceQuotaService<T> {
    protected abstract T createKeyFrom(SpaceInst var1);

    @Override
    @NonNull
    public Quota getQuotaReachedFromSpacePath(T key) {
        Quota spaceQuotaReached = new Quota();
        if (((AbstractSpaceQuotaKey)key).isValid()) {
            try {
                spaceQuotaReached = this.get(key);
                SpaceInst fromSpaceTheQuotaIsReached = AdministrationServiceProvider.getAdminService().getSpaceInstById(((AbstractSpaceQuotaKey)key).getResourceId());
                while (!spaceQuotaReached.isReached() && !fromSpaceTheQuotaIsReached.isRoot()) {
                    fromSpaceTheQuotaIsReached = AdministrationServiceProvider.getAdminService().getSpaceInstById(fromSpaceTheQuotaIsReached.getDomainFatherId());
                    spaceQuotaReached = this.get(this.createKeyFrom(fromSpaceTheQuotaIsReached));
                }
            }
            catch (QuotaException | AdminException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
            if (!spaceQuotaReached.isReached()) {
                spaceQuotaReached = new Quota();
            }
        }
        return spaceQuotaReached;
    }

    @Override
    public Quota verify(T key, Quota quota, AbstractQuotaCountingOffset countingOffset) throws QuotaException {
        if (!this.isActivated()) {
            return new Quota();
        }
        T currentKey = key;
        Quota verifiedQuota = this.verifyQuota(quota, countingOffset);
        while (((AbstractSpaceQuotaKey)currentKey).isValid() && !((AbstractSpaceQuotaKey)currentKey).getSpace().isRoot()) {
            currentKey = this.createKeyFrom(OrganizationControllerProvider.getOrganisationController().getSpaceInstById(((AbstractSpaceQuotaKey)currentKey).getSpace().getDomainFatherId()));
            verifiedQuota = this.verifyQuota(this.get(currentKey), countingOffset);
        }
        return verifiedQuota;
    }
}

