/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.ComponentOrderComparator;
import org.silverpeas.core.admin.space.SpaceInstLight;

public class Space {
    private static ComponentOrderComparator comparator = new ComponentOrderComparator();
    private SpaceInstLight spaceInstLight;
    private Map<String, ComponentInstLight> components = new LinkedHashMap<String, ComponentInstLight>();
    private List<SpaceInstLight> subspaces = new ArrayList<SpaceInstLight>();

    public SpaceInstLight getSpaceInstLight() {
        return this.spaceInstLight;
    }

    public void setSpaceInstLight(SpaceInstLight spaceInstLight) {
        this.spaceInstLight = spaceInstLight;
    }

    public List<ComponentInstLight> getComponents() {
        ArrayList<ComponentInstLight> list = new ArrayList<ComponentInstLight>(this.components.values());
        list.sort(comparator);
        return list;
    }

    public void clearComponents() {
        this.components.clear();
    }

    public List<String> getComponentIds() {
        ArrayList<String> ids = new ArrayList<String>(this.components.size());
        for (ComponentInstLight component : this.components.values()) {
            ids.add(component.getId());
        }
        return ids;
    }

    public void setComponents(List<ComponentInstLight> components) {
        for (ComponentInstLight component : components) {
            this.components.put(component.getId(), component);
        }
    }

    public List<SpaceInstLight> getSubspaces() {
        return this.subspaces;
    }

    public void setSubspaces(List<SpaceInstLight> subspaces) {
        this.subspaces = subspaces;
    }

    public void addComponent(ComponentInstLight component) {
        this.components.put(component.getId(), component);
    }

    public void removeComponent(ComponentInstLight component) {
        this.components.remove(component.getId());
    }

    public boolean containsComponent(String componentId) {
        return this.components.containsKey(componentId);
    }

    public ComponentInstLight getComponent(String componentId) {
        ComponentInstLight component = this.components.get(componentId);
        if (component != null && this.getSpaceInstLight().isRemoved()) {
            component.setStatus("R");
        }
        return component;
    }

    public void updateSubspace(SpaceInstLight subspace) {
        int index = this.subspaces.indexOf(subspace);
        if (index != -1) {
            this.subspaces.remove(index);
            this.subspaces.add(index, subspace);
        }
    }

    public void updateComponent(ComponentInstLight component) {
        this.components.replace(component.getId(), component);
    }
}

