/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.util.StringUtil;

@Technical
@Bean
@Singleton
public class AdminCache {
    private boolean useCache = true;
    private boolean useSpaceInstCache = true;
    private Map<Integer, SpaceInst> spaceInstCache = new ConcurrentHashMap<Integer, SpaceInst>();
    private boolean useComponentInstCache = true;
    private Map<Integer, ComponentInst> componentInstCache = new ConcurrentHashMap<Integer, ComponentInst>();
    private boolean useProfileInstCache = true;
    private Map<String, ProfileInst> profileInstCache = new ConcurrentHashMap<String, ProfileInst>();
    private boolean useUserDetailCache = true;
    private Map<String, UserDetail> userDetailCache = new ConcurrentHashMap<String, UserDetail>();
    private boolean useManageableSpaceIdsCache = true;
    private Map<String, String[]> manageableSpaceIdsCache = new ConcurrentHashMap<String, String[]>();
    private boolean useAvailCompoIdsCache = true;
    private Map<String, Map<String, String[]>> availCompoIdsCache = new ConcurrentHashMap<String, Map<String, String[]>>();
    private boolean useProfileIdsCache = true;
    private Map<String, String[]> profileIdsCache = new ConcurrentHashMap<String, String[]>();

    public void setCacheAvailable(boolean useCache) {
        this.useCache = useCache;
    }

    public void resetCache() {
        this.spaceInstCache.clear();
        this.componentInstCache.clear();
        this.profileInstCache.clear();
        this.userDetailCache.clear();
        this.manageableSpaceIdsCache.clear();
        this.availCompoIdsCache.clear();
        this.profileIdsCache.clear();
    }

    public void resetSpaceInst() {
        if (this.useCache && this.useSpaceInstCache) {
            this.spaceInstCache.clear();
        }
    }

    public void putSpaceInst(SpaceInst spaceInst) {
        if (this.useCache && this.useSpaceInstCache) {
            this.spaceInstCache.put(spaceInst.getLocalId(), spaceInst);
        }
    }

    public void removeSpaceInst(int spaceId) {
        if (this.useCache && this.useSpaceInstCache) {
            Optional.ofNullable(this.spaceInstCache.remove(spaceId)).ifPresent(this::resetParentSpaceData);
        }
    }

    public Optional<SpaceInst> getSpaceInst(int spaceId) {
        if (this.useCache && this.useSpaceInstCache) {
            return Optional.ofNullable(this.spaceInstCache.get(spaceId));
        }
        return Optional.empty();
    }

    private void removeUserInSpaceInst(String userId) {
        this.removeTokenInSpaceInst(userId, false);
    }

    private void removeGroupInSpaceInst(String groupId) {
        this.removeTokenInSpaceInst(groupId, true);
    }

    private void removeTokenInSpaceInst(String tokenId, boolean isGroup) {
        for (SpaceInst theSpace : this.spaceInstCache.values()) {
            for (SpaceProfileInst spaceProfile : theSpace.getAllSpaceProfilesInst()) {
                if (isGroup) {
                    spaceProfile.removeGroup(tokenId);
                    continue;
                }
                spaceProfile.removeUser(tokenId);
            }
            this.removeInProfilesForAllComponentInstances(tokenId, isGroup, theSpace.getAllComponentsInst());
        }
    }

    private void removeInProfilesForAllComponentInstances(String tokenId, boolean isGroup, Collection<ComponentInst> componentInstances) {
        for (ComponentInst theComponent : componentInstances) {
            for (ProfileInst theProfile : theComponent.getAllProfilesInst()) {
                if (isGroup) {
                    theProfile.removeGroup(tokenId);
                    continue;
                }
                theProfile.removeUser(tokenId);
            }
        }
    }

    public void resetComponentInst() {
        if (this.useCache && this.useComponentInstCache) {
            this.componentInstCache.clear();
        }
    }

    public void putComponentInst(ComponentInst componentInst) {
        if (this.useCache && this.useComponentInstCache) {
            this.componentInstCache.put(componentInst.getLocalId(), componentInst);
        }
    }

    private void removeComponentInst(ComponentInst componentInst) {
        if (this.useCache && this.useComponentInstCache) {
            this.componentInstCache.remove(componentInst.getLocalId());
        }
    }

    public Optional<ComponentInst> getComponentInst(int componentId) {
        if (this.useCache && this.useComponentInstCache) {
            return Optional.ofNullable(this.componentInstCache.get(componentId));
        }
        return Optional.empty();
    }

    private void removeUserInComponentInst(String userId) {
        this.removeTokenInComponentInst(userId, false);
    }

    private void removeGroupInComponentInst(String groupId) {
        this.removeTokenInComponentInst(groupId, true);
    }

    private void removeTokenInComponentInst(String tokenId, boolean isGroup) {
        this.removeInProfilesForAllComponentInstances(tokenId, isGroup, this.componentInstCache.values());
    }

    private void removeSpaceComponentsInst(int spaceId) {
        Collection<ComponentInst> theComponents = this.componentInstCache.values();
        for (ComponentInst theComponent : theComponents) {
            Integer localSpaceId = this.getLocalSpaceId(theComponent.getDomainFatherId());
            if (localSpaceId == null || spaceId != localSpaceId) continue;
            this.removeComponentsProfilesInst(theComponent.getLocalId());
            this.removeComponentInst(theComponent);
        }
    }

    public void putProfileInst(ProfileInst profileInst) {
        if (this.useCache && this.useProfileInstCache) {
            this.profileInstCache.put(profileInst.getId(), profileInst);
        }
    }

    private void removeProfileInst(ProfileInst profileInst) {
        if (this.useCache && this.useProfileInstCache) {
            this.profileInstCache.remove(profileInst.getId());
        }
    }

    public Optional<ProfileInst> getProfileInst(String profileId) {
        if (this.useCache && this.useProfileInstCache) {
            return Optional.ofNullable(this.profileInstCache.get(profileId));
        }
        return Optional.empty();
    }

    private void removeUserInProfileInst(String userId) {
        this.removeTokenInProfileInst(userId, false);
    }

    private void removeGroupInProfileInst(String groupId) {
        this.removeTokenInProfileInst(groupId, true);
    }

    private void removeTokenInProfileInst(String tokenId, boolean isGroup) {
        Collection<ProfileInst> profiles = this.profileInstCache.values();
        for (ProfileInst profile : profiles) {
            if (isGroup) {
                profile.removeGroup(tokenId);
                continue;
            }
            profile.removeUser(tokenId);
        }
    }

    private void removeComponentsProfilesInst(int componentId) {
        Collection<ProfileInst> theProfiles = this.profileInstCache.values();
        for (ProfileInst theProfile : theProfiles) {
            if (componentId != theProfile.getComponentFatherId()) continue;
            this.removeProfileInst(theProfile);
        }
    }

    public void putUserDetail(String userId, UserDetail userDetail) {
        if (this.useCache && this.useUserDetailCache) {
            this.userDetailCache.put(userId, userDetail);
        }
    }

    private void removeUserDetail(String userId) {
        if (this.useCache && this.useUserDetailCache) {
            this.userDetailCache.remove(userId);
        }
    }

    public Optional<UserDetail> getUserDetail(String userId) {
        if (this.useCache && this.useUserDetailCache) {
            return Optional.ofNullable(this.userDetailCache.get(userId));
        }
        return Optional.empty();
    }

    private void resetManageableSpaceIds() {
        this.manageableSpaceIdsCache.clear();
    }

    public void putManageableSpaceIds(String userId, String[] spaceIds) {
        if (this.useCache && this.useManageableSpaceIdsCache) {
            this.manageableSpaceIdsCache.put(userId, spaceIds);
        }
    }

    private void removeManageableSpaceIds(String userId) {
        if (this.useCache && this.useManageableSpaceIdsCache) {
            this.manageableSpaceIdsCache.remove(userId);
        }
    }

    public Optional<String[]> getManageableSpaceIds(String userId) {
        if (this.useCache && this.useManageableSpaceIdsCache) {
            return Optional.ofNullable(this.manageableSpaceIdsCache.get(userId));
        }
        return Optional.empty();
    }

    private void resetAvailCompoIds() {
        this.availCompoIdsCache.clear();
    }

    public void putAvailCompoIds(String spaceId, String userId, String[] compoIds) {
        if (this.useCache && this.useAvailCompoIdsCache) {
            Map spaceTable = this.availCompoIdsCache.computeIfAbsent(spaceId, s -> new ConcurrentHashMap());
            spaceTable.put(userId, compoIds);
        }
    }

    private void removeAvailCompoIdsForUser(String userId) {
        if (this.useCache && this.useAvailCompoIdsCache) {
            for (Map<String, String[]> spaceTable : this.availCompoIdsCache.values()) {
                spaceTable.remove(userId);
            }
        }
    }

    public Optional<String[]> getAvailCompoIds(int spaceId, String userId) {
        Map<String, String[]> spaceTable;
        if (this.useCache && this.useAvailCompoIdsCache && (spaceTable = this.availCompoIdsCache.get(String.valueOf(spaceId))) != null) {
            return Optional.ofNullable(spaceTable.get(userId));
        }
        return Optional.empty();
    }

    private void resetProfileIds() {
        this.profileIdsCache.clear();
    }

    public void putProfileIds(String userId, String[] profileIds) {
        if (this.useCache && this.useProfileIdsCache) {
            this.profileIdsCache.put(userId, profileIds);
        }
    }

    private void removeProfileIds(String userId) {
        if (this.useCache && this.useProfileIdsCache) {
            this.profileIdsCache.remove(userId);
        }
    }

    public Optional<String[]> getProfileIds(String userId) {
        if (this.useCache && this.useProfileIdsCache) {
            return Optional.ofNullable(this.profileIdsCache.get(userId));
        }
        return Optional.empty();
    }

    public void opAddSpace(SpaceInst theSpace) {
        this.resetParentSpaceData(theSpace);
        this.resetManageableSpaceIds();
    }

    public void opUpdateSpace(SpaceInst theSpace) {
        this.opResetSpace(theSpace);
    }

    public void opRemoveSpace(SpaceInst theSpace) {
        this.opResetSpace(theSpace);
    }

    private void resetParentSpaceData(SpaceInst theSpace) {
        if (theSpace.getDomainFatherId() != null && !theSpace.getDomainFatherId().isEmpty() && !theSpace.getDomainFatherId().equals("0")) {
            Optional.ofNullable(this.getLocalSpaceId(theSpace.getDomainFatherId())).flatMap(this::getSpaceInst).ifPresent(SpaceInst::resetData);
        }
    }

    private void opResetSpace(SpaceInst theSpace) {
        this.resetParentSpaceData(theSpace);
        this.removeSpaceComponentsInst(theSpace.getLocalId());
        this.removeSpaceInst(theSpace.getLocalId());
        this.resetProfileIds();
        this.resetAvailCompoIds();
        this.resetManageableSpaceIds();
    }

    public void opAddComponent(ComponentInst component) {
        this.opResetComponent(component);
    }

    public void opUpdateComponent(ComponentInst component) {
        this.opResetComponent(component);
    }

    public void opRemoveComponent(ComponentInst component) {
        this.opResetComponent(component);
    }

    private void opResetComponent(ComponentInst component) {
        this.removeComponentsProfilesInst(component.getLocalId());
        this.removeComponent(component);
        this.resetProfileIds();
        this.resetAvailCompoIds();
    }

    private void removeComponent(ComponentInst component) {
        Integer spaceId = this.getLocalSpaceId(component.getDomainFatherId());
        if (spaceId != null) {
            Optional<SpaceInst> theSpace = this.getSpaceInst(spaceId);
            theSpace.ifPresent(s -> this.removeSpaceInst(s.getLocalId()));
        }
        this.removeComponentInst(component);
    }

    public void opAddProfile(ProfileInst profile) {
        this.opResetProfile(profile);
    }

    public void opUpdateProfile(ProfileInst profile) {
        this.opResetProfile(profile);
    }

    public void opRemoveProfile(ProfileInst profile) {
        this.opResetProfile(profile);
    }

    private void opResetProfile(ProfileInst profile) {
        Optional<ComponentInst> theComponent = this.getComponentInst(profile.getComponentFatherId());
        theComponent.ifPresent(this::removeComponent);
        this.removeProfileInst(profile);
        this.resetProfileIds();
        this.resetAvailCompoIds();
    }

    public void opAddSpaceProfile(SpaceProfileInst profile) {
        Integer spaceId = this.getLocalSpaceId(profile.getSpaceFatherId());
        if (spaceId != null) {
            Optional<SpaceInst> theSpace = this.getSpaceInst(spaceId);
            theSpace.ifPresent(s -> s.addSpaceProfileInst(profile));
        }
        this.resetManageableSpaceIds();
    }

    public void opUpdateSpaceProfile(SpaceProfileInst profile) {
        Integer spaceId = this.getLocalSpaceId(profile.getSpaceFatherId());
        if (spaceId != null) {
            Optional<SpaceInst> theSpace = this.getSpaceInst(spaceId);
            theSpace.ifPresent(s -> {
                s.deleteSpaceProfileInst(profile);
                s.addSpaceProfileInst(profile);
            });
        }
        this.resetManageableSpaceIds();
    }

    public void opRemoveSpaceProfile(SpaceProfileInst profile) {
        Integer spaceId = this.getLocalSpaceId(profile.getSpaceFatherId());
        if (spaceId != null) {
            Optional<SpaceInst> theSpace = this.getSpaceInst(spaceId);
            theSpace.ifPresent(s -> s.deleteSpaceProfileInst(profile));
        }
        this.resetManageableSpaceIds();
    }

    public void opAddGroup(Group group) {
        if (StringUtil.isDefined((String)group.getSuperGroupId())) {
            String[] uids;
            for (String uid : uids = group.getUserIds()) {
                this.opResetUserRights(uid);
            }
        }
    }

    public void resetOnUpdateGroup() {
        this.resetProfileIds();
        this.resetAvailCompoIds();
        this.resetManageableSpaceIds();
    }

    public void opRemoveGroup(Group group) {
        String groupId = group.getId();
        this.removeGroupInSpaceInst(groupId);
        this.removeGroupInComponentInst(groupId);
        this.removeGroupInProfileInst(groupId);
        this.resetProfileIds();
        this.resetAvailCompoIds();
        this.resetManageableSpaceIds();
    }

    public void opAddUserInGroup(String userId) {
        this.opResetUserRights(userId);
    }

    public void opRemoveUserFromGroup(String userId) {
        this.opResetUserRights(userId);
    }

    public void opUpdateUser(UserDetail user) {
        this.removeUserDetail(user.getId());
    }

    public void opRemoveUser(UserDetail user) {
        String userId = user.getId();
        this.removeUserDetail(userId);
        this.removeProfileIds(userId);
        this.removeManageableSpaceIds(userId);
        this.removeAvailCompoIdsForUser(userId);
        this.removeUserInSpaceInst(userId);
        this.removeUserInComponentInst(userId);
        this.removeUserInProfileInst(userId);
    }

    private void opResetUserRights(String userId) {
        this.removeProfileIds(userId);
        this.removeManageableSpaceIds(userId);
        this.removeAvailCompoIdsForUser(userId);
    }

    private Integer getLocalSpaceId(String spaceId) {
        boolean isSpaceIdDefined = StringUtil.isDefined((String)spaceId);
        if (isSpaceIdDefined && spaceId.startsWith("WA")) {
            return Integer.parseInt(spaceId.substring("WA".length()));
        }
        return !isSpaceIdDefined ? null : Integer.valueOf(Integer.parseInt(spaceId));
    }
}

