/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.kernel.util.StringUtil;

public class SpaceWithSubSpacesAndComponents {
    private SpaceInstLight space;
    private List<SpaceWithSubSpacesAndComponents> subSpaces;
    private List<SilverpeasComponentInstance> components;

    public SpaceWithSubSpacesAndComponents(SpaceInstLight space) {
        this.space = space;
    }

    void setSubSpaces(List<SpaceWithSubSpacesAndComponents> subSpaces) {
        this.subSpaces = subSpaces;
    }

    void setComponents(List<SilverpeasComponentInstance> components) {
        this.components = components;
    }

    public SpaceInstLight getSpace() {
        return this.space;
    }

    public List<SpaceWithSubSpacesAndComponents> getSubSpaces() {
        return this.subSpaces;
    }

    public List<SilverpeasComponentInstance> getComponents() {
        return this.components;
    }

    public ComponentInstanceSelector componentInstanceSelector() {
        return new ComponentInstanceSelector(this);
    }

    public static class ComponentInstanceSelector {
        private final SpaceWithSubSpacesAndComponents currentSpaceView;
        private Boolean inAllSpaces;
        private Boolean inCurrentSpace;
        private Set<String> spaces = Collections.emptySet();
        private Set<String> componentIdsToExclude = Collections.emptySet();

        private ComponentInstanceSelector(SpaceWithSubSpacesAndComponents currentSpaceView) {
            this.currentSpaceView = currentSpaceView;
        }

        public ComponentInstanceSelector fromAllSpaces() {
            this.inAllSpaces = true;
            this.inCurrentSpace = false;
            return this;
        }

        public ComponentInstanceSelector fromSpaces(Set<String> spaces) {
            this.inAllSpaces = false;
            this.inCurrentSpace = true;
            this.spaces = spaces;
            return this;
        }

        public ComponentInstanceSelector fromSubSpacesOfSpaces(Set<String> spaces) {
            this.inAllSpaces = false;
            this.inCurrentSpace = false;
            this.spaces = spaces;
            return this;
        }

        public ComponentInstanceSelector excludingComponentInstances(Set<String> componentIdsToExclude) {
            this.componentIdsToExclude = componentIdsToExclude;
            return this;
        }

        public List<SilverpeasComponentInstance> select() {
            if (this.inAllSpaces == null || this.inCurrentSpace == null) {
                throw new IllegalStateException("Please parametrize the selector by using at least fromAllSpaces, fromSpaces or fromSubSpacesOfSpaces method");
            }
            ArrayList<SilverpeasComponentInstance> result = new ArrayList<SilverpeasComponentInstance>();
            this.fillComponentIdsFromSpaceView(this.currentSpaceView, result, this.inAllSpaces, this.inCurrentSpace);
            return result;
        }

        private void fillComponentIdsFromSpaceView(SpaceWithSubSpacesAndComponents currentSpaceView, List<SilverpeasComponentInstance> result, boolean aggregateFromAllSpaces, boolean aggregateFromCurrentSpace) {
            SpaceInstLight currentSpace = currentSpaceView.getSpace();
            if (currentSpace != null) {
                boolean isCurrentSpaceCandidate;
                boolean bl = isCurrentSpaceCandidate = StringUtil.isDefined((String)currentSpace.getFatherId()) && (this.spaces.contains(currentSpace.getId()) || this.spaces.contains(String.valueOf(currentSpace.getLocalId())));
                if ((aggregateFromAllSpaces || aggregateFromCurrentSpace && isCurrentSpaceCandidate) && currentSpaceView.getComponents() != null) {
                    currentSpaceView.getComponents().stream().filter(a2 -> !this.componentIdsToExclude.contains(a2.getId())).forEach(result::add);
                }
                if (currentSpaceView.getSubSpaces() != null) {
                    currentSpaceView.getSubSpaces().forEach(s -> this.fillComponentIdsFromSpaceView((SpaceWithSubSpacesAndComponents)s, result, aggregateFromAllSpaces || isCurrentSpaceCandidate, aggregateFromCurrentSpace));
                }
            }
        }
    }
}

