/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.quota.service;

import javax.inject.Inject;
import org.silverpeas.core.admin.quota.QuotaKey;
import org.silverpeas.core.admin.quota.constant.QuotaLoad;
import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.admin.quota.exception.QuotaFullException;
import org.silverpeas.core.admin.quota.exception.QuotaNotEnoughException;
import org.silverpeas.core.admin.quota.exception.QuotaOutOfBoundsException;
import org.silverpeas.core.admin.quota.model.Quota;
import org.silverpeas.core.admin.quota.offset.AbstractQuotaCountingOffset;
import org.silverpeas.core.admin.quota.offset.SimpleQuotaCountingOffset;
import org.silverpeas.core.admin.quota.repository.QuotaRepository;
import org.silverpeas.core.admin.quota.service.QuotaService;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.TransactionRuntimeException;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.util.Process;

public abstract class AbstractQuotaService<T extends QuotaKey>
implements QuotaService<T> {
    @Inject
    private QuotaRepository quotaRepository;

    @Override
    public Quota initialize(T key, long maxCount) throws QuotaException {
        return this.initialize(key, 0L, maxCount);
    }

    @Override
    public Quota initialize(T key, Quota quota) throws QuotaException {
        return this.initialize(key, quota.getMinCount(), quota.getMaxCount());
    }

    @Override
    public Quota initialize(T key, long minCount, long maxCount) throws QuotaException {
        return (Quota)this.requiredTransaction(() -> {
            Quota quota = this.getByQuotaKey(key);
            if (!quota.exists()) {
                if (maxCount == 0L) {
                    return quota;
                }
                quota.setType(key.getQuotaType());
                quota.setResourceId(key.getResourceId());
            }
            if (!quota.exists() || minCount != quota.getMinCount() || maxCount != quota.getMaxCount()) {
                quota.setMinCount(minCount);
                quota.setMaxCount(maxCount);
                quota.validate();
                this.quotaRepository.saveAndFlush((IdentifiableEntity)quota);
            }
            return quota;
        });
    }

    @Override
    public Quota get(T key) throws QuotaException {
        if (!this.isActivated()) {
            return new Quota();
        }
        return (Quota)this.requiredTransaction(() -> {
            Quota quota = this.getByQuotaKey(key);
            if (quota.exists()) {
                long currentCount;
                long l = currentCount = quota.isNotUnlimitedLoad() ? this.getCurrentCount(key) : 0L;
                if (quota.getCount() != currentCount) {
                    quota.setCount(currentCount);
                    this.quotaRepository.saveAndFlush((IdentifiableEntity)quota);
                }
            }
            return quota;
        });
    }

    private Quota getByQuotaKey(T key) {
        Quota quota = null;
        if (key.isValid()) {
            quota = this.quotaRepository.getByTypeAndResourceId(key.getQuotaType().name(), key.getResourceId());
        }
        if (quota == null) {
            quota = new Quota();
        }
        return quota;
    }

    @Override
    public Quota verify(T key) throws QuotaException {
        return this.verify(key, SimpleQuotaCountingOffset.from(0L));
    }

    @Override
    public Quota verify(T key, AbstractQuotaCountingOffset countingOffset) throws QuotaException {
        if (!this.isActivated()) {
            return new Quota();
        }
        return this.verify(key, this.get(key), countingOffset);
    }

    @Override
    public Quota verify(T key, Quota quota) throws QuotaException {
        if (!this.isActivated()) {
            return new Quota();
        }
        return this.verify(key, quota, SimpleQuotaCountingOffset.from(0L));
    }

    @Override
    public Quota verify(T key, Quota quota, AbstractQuotaCountingOffset countingOffset) throws QuotaException {
        return this.verifyQuota(quota, countingOffset);
    }

    protected final Quota verifyQuota(Quota quota, AbstractQuotaCountingOffset countingOffset) throws QuotaException {
        if (!this.isActivated()) {
            return new Quota();
        }
        if (quota.exists()) {
            Quota copy = new Quota(quota);
            copy.setQuotaId(Long.parseLong(quota.getId()));
            long offset = countingOffset.getOffset();
            copy.setCount(quota.getCount() + offset);
            QuotaLoad quotaLoad = copy.getLoad();
            if (QuotaLoad.OUT_OF_BOUNDS.equals((Object)quotaLoad)) {
                throw new QuotaOutOfBoundsException(quota);
            }
            if (QuotaLoad.FULL.equals((Object)quotaLoad)) {
                throw new QuotaFullException(quota);
            }
            if (QuotaLoad.NOT_ENOUGH.equals((Object)quotaLoad)) {
                throw new QuotaNotEnoughException(quota);
            }
            return copy;
        }
        return quota;
    }

    @Override
    public void remove(T key) {
        Transaction.performInOne(() -> {
            Quota quota = this.getByQuotaKey(key);
            if (quota.exists()) {
                this.quotaRepository.delete((IdentifiableEntity[])new Quota[]{quota});
            }
            return null;
        });
    }

    private <R> R requiredTransaction(Process<R> process) throws QuotaException {
        try {
            return (R)Transaction.performInOne(process);
        }
        catch (TransactionRuntimeException e) {
            if (e.getCause() instanceof QuotaException) {
                throw (QuotaException)((Object)e.getCause());
            }
            throw e;
        }
    }

    protected abstract boolean isActivated();
}

